/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.netlib.blas.BLAS;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.BinaryVectorUtils;
import pitt.search.semanticvectors.vectors.ComplexVector;
import pitt.search.semanticvectors.vectors.ComplexVectorUtils;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.RealVectorUtils;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorUtils {
    private static final Logger logger = Logger.getLogger(VectorUtils.class.getCanonicalName());

    public static int getNearestVector(Vector vector, Vector[] candidates) {
        int nearest = 0;
        double maxSim = vector.measureOverlap(candidates[0]);
        for (int i = 1; i < candidates.length; ++i) {
            double thisDist = vector.measureOverlap(candidates[i]);
            if (!(thisDist > maxSim)) continue;
            maxSim = thisDist;
            nearest = i;
        }
        return nearest;
    }

    public static double compareWithProjection(Vector testVector, ArrayList<Vector> vectors) {
        float score = 0.0f;
        for (Vector vector : vectors) {
            score = (float)((double)score + Math.pow(testVector.measureOverlap(vector), 2.0));
        }
        return (float)Math.sqrt(score);
    }

    public static void orthogonalizeVectors(List<Vector> list) {
        switch (list.get(0).getVectorType()) {
            case REAL: {
                RealVectorUtils.orthogonalizeVectors(list);
                break;
            }
            case COMPLEX: {
                ComplexVectorUtils.orthogonalizeVectors(list);
                break;
            }
            case BINARY: {
                BinaryVectorUtils.orthogonalizeVectors(list);
                break;
            }
            default: {
                throw new IncompatibleVectorsException("Type not recognized: " + (Object)((Object)list.get(0).getVectorType()));
            }
        }
    }

    public static Vector weightedSuperposition(Vector left, double leftWeight, Vector right, double rightWeight) {
        if (left.getVectorType() != right.getVectorType() || left.getDimension() != right.getDimension()) {
            throw new IncompatibleVectorsException(String.format("Incompatible vectors:\n%s\n%s", left.toString(), right.toString()));
        }
        switch (left.getVectorType()) {
            case REAL: 
            case COMPLEX: {
                Vector superposition = VectorFactory.createZeroVector(left.getVectorType(), left.getDimension());
                superposition.superpose(left, leftWeight, null);
                superposition.superpose(right, rightWeight, null);
                superposition.normalize();
                return superposition;
            }
            case BINARY: {
                return BinaryVectorUtils.weightedSuperposition((BinaryVector)left, leftWeight, (BinaryVector)right, rightWeight);
            }
        }
        throw new IncompatibleVectorsException("Type not recognized: " + (Object)((Object)left.getVectorType()));
    }

    public static short[] generateRandomVector(int seedLength, int dimension, Random random) {
        int testPlace;
        boolean[] randVector = new boolean[dimension];
        short[] randIndex = new short[seedLength];
        int entryCount = 0;
        while (entryCount < seedLength / 2) {
            testPlace = random.nextInt(dimension);
            if (randVector[testPlace]) continue;
            randVector[testPlace] = true;
            randIndex[entryCount] = new Integer(testPlace + 1).shortValue();
            ++entryCount;
        }
        while (entryCount < seedLength) {
            testPlace = random.nextInt(dimension);
            if (randVector[testPlace]) continue;
            randVector[testPlace] = true;
            randIndex[entryCount] = new Integer((1 + testPlace) * -1).shortValue();
            ++entryCount;
        }
        return randIndex;
    }

    public static double scalarProduct(Vector v1, Vector v2, FlagConfig flagConfig, BLAS blas) throws IncompatibleVectorsException {
        if (!v1.getVectorType().equals((Object)v2.getVectorType())) {
            throw new IncompatibleVectorsException();
        }
        switch (v1.getVectorType()) {
            case REAL: {
                return blas.sdot(v1.getDimension(), ((RealVector)v1).getCoordinates(), 1, ((RealVector)v2).getCoordinates(), 1);
            }
            case COMPLEX: {
                return blas.sdot(v1.getDimension() * 2, ((ComplexVector)v1).getCoordinates(), 1, ((ComplexVector)v2).getCoordinates(), 1);
            }
            case BINARY: {
                ((BinaryVector)v1).tallyVotes();
                ((BinaryVector)v2).tallyVotes();
                return v1.measureOverlap(v2);
            }
        }
        return 0.0;
    }

    public static double scalarProduct(Vector v1, Vector v2, FlagConfig flagConfig, BLAS blas, int[] permutations) throws IncompatibleVectorsException {
        if (permutations == null) {
            return VectorUtils.scalarProduct(v1, v2, flagConfig, blas);
        }
        if (!v1.getVectorType().equals((Object)v2.getVectorType()) || !v1.getVectorType().equals((Object)VectorType.REAL)) {
            throw new IncompatibleVectorsException();
        }
        double score = 0.0;
        for (int q = 0; q < v1.getDimension(); ++q) {
            score += (double)(((RealVector)v1).getCoordinates()[permutations[q]] * ((RealVector)v2).getCoordinates()[q]);
        }
        return score;
    }

    public static void superposeInPlace(Vector toBeAdded, Vector toBeAltered, FlagConfig flagConfig, BLAS blas, double weight, int[] permutation) throws IncompatibleVectorsException {
        if (permutation == null) {
            VectorUtils.superposeInPlace(toBeAdded, toBeAltered, flagConfig, blas, weight);
        } else {
            if (!toBeAdded.getVectorType().equals((Object)toBeAltered.getVectorType()) || !toBeAdded.getVectorType().equals((Object)VectorType.REAL)) {
                throw new IncompatibleVectorsException();
            }
            for (int q = 0; q < toBeAdded.getDimension(); ++q) {
                float[] fArray = ((RealVector)toBeAltered).getCoordinates();
                int n = permutation[q];
                fArray[n] = (float)((double)fArray[n] + (double)((RealVector)toBeAdded).getCoordinates()[q] * weight);
            }
        }
    }

    public static void superposeInPlace(Vector toBeAdded, Vector toBeAltered, FlagConfig flagConfig, BLAS blas, double weight) throws IncompatibleVectorsException {
        if (!toBeAdded.getVectorType().equals((Object)toBeAltered.getVectorType())) {
            throw new IncompatibleVectorsException();
        }
        switch (toBeAdded.getVectorType()) {
            case REAL: {
                blas.saxpy(flagConfig.dimension(), (float)weight, ((RealVector)toBeAdded).getCoordinates(), 1, ((RealVector)toBeAltered).getCoordinates(), 1);
                break;
            }
            case COMPLEX: {
                blas.saxpy(flagConfig.dimension() * 2, (float)weight, ((ComplexVector)toBeAdded).getCoordinates(), 1, ((ComplexVector)toBeAltered).getCoordinates(), 1);
                break;
            }
            case BINARY: {
                ((BinaryVector)toBeAdded).tallyVotes();
                toBeAltered.superpose(toBeAdded, weight, null);
                break;
            }
        }
    }

    public static boolean containsNaN(Vector toTest) {
        if (toTest.getVectorType().equals((Object)VectorType.BINARY)) {
            return false;
        }
        float[] coords = new float[]{};
        if (toTest.getVectorType().equals((Object)VectorType.REAL)) {
            coords = ((RealVector)toTest).getCoordinates();
        } else if (toTest.getVectorType().equals((Object)VectorType.COMPLEX)) {
            coords = ((ComplexVector)toTest).getCoordinates();
        }
        for (float x : coords) {
            if (!Float.isNaN(x)) continue;
            return true;
        }
        return false;
    }
}

