/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.Random;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.ComplexVector;
import pitt.search.semanticvectors.vectors.PermutationVector;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorFactory {
    private static final BinaryVector binaryInstance = new BinaryVector(0);
    private static final RealVector realInstance = new RealVector(0);
    private static final ComplexVector complexInstance = new ComplexVector(0, ComplexVector.Mode.POLAR_SPARSE);
    private static final ComplexVector complexFlatInstance = new ComplexVector(0, ComplexVector.Mode.CARTESIAN);

    public static Vector createZeroVector(VectorType type, int dimension) {
        switch (type) {
            case BINARY: {
                return new BinaryVector(dimension);
            }
            case REAL: {
                return new RealVector(dimension);
            }
            case COMPLEX: 
            case COMPLEXFLAT: {
                return new ComplexVector(dimension, ComplexVector.Mode.POLAR_SPARSE);
            }
            case PERMUTATION: {
                return new PermutationVector(dimension);
            }
        }
        throw new IllegalArgumentException("Unrecognized VectorType: " + (Object)((Object)type));
    }

    public static Vector generateRandomVector(VectorType type, int dimension, int numEntries, Random random) {
        if (2 * numEntries > dimension && !type.equals((Object)VectorType.COMPLEX) && numEntries != dimension) {
            throw new RuntimeException("Requested " + numEntries + " to be filled in sparse vector of dimension " + dimension + ". This is not sparse and may cause problems.");
        }
        switch (type) {
            case BINARY: {
                return binaryInstance.generateRandomVector(dimension, numEntries, random);
            }
            case REAL: {
                return realInstance.generateRandomVector(dimension, numEntries, random);
            }
            case COMPLEX: {
                if (!ComplexVector.getDominantMode().equals((Object)ComplexVector.Mode.HERMITIAN)) {
                    ComplexVector.setDominantMode(ComplexVector.Mode.POLAR_DENSE);
                }
                return complexInstance.generateRandomVector(dimension, numEntries, random);
            }
            case COMPLEXFLAT: {
                ComplexVector.setDominantMode(ComplexVector.Mode.CARTESIAN);
                return complexInstance.generateRandomVector(dimension, numEntries, random);
            }
        }
        throw new IllegalArgumentException("Unrecognized VectorType: " + (Object)((Object)type));
    }

    public static int getLuceneByteSize(VectorType vectorType, int dimension) {
        switch (vectorType) {
            case BINARY: {
                return 8 * (dimension / 64);
            }
            case REAL: {
                return 4 * dimension;
            }
            case COMPLEX: 
            case COMPLEXFLAT: {
                return 8 * dimension;
            }
        }
        throw new IllegalArgumentException("Unrecognized VectorType: " + (Object)((Object)vectorType));
    }
}

