/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.ArrayList;
import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class SemanticVectorCollider {
    public static void main(String[] args) {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        args = flagConfig.remainingArgs;
        Random random = new Random();
        int iterations = 1000;
        int superpositions = 15000;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        System.out.println("Number of iterations " + iterations);
        System.out.println("Number of superpositions per iteration (if no collision occurs) " + superpositions);
        System.out.println("Vector type " + (Object)((Object)flagConfig.vectortype()));
        System.out.println("Dimension " + flagConfig.dimension());
        System.out.println("Seed length " + flagConfig.seedlength());
        int overlapcnt = 0;
        int overlaprank = 0;
        ArrayList<Double> overlapRank = new ArrayList<Double>();
        boolean overlapcount = false;
        double overlapscore = 0.0;
        ArrayList<Double> overlapScore = new ArrayList<Double>();
        for (int cnt = 0; cnt < iterations; ++cnt) {
            System.err.println("\nIteration " + cnt);
            Vector originalVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
            Vector superPosition = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
            superPosition.superpose(originalVector, 1.0, null);
            if (flagConfig.vectortype() == VectorType.BINARY) {
                ((BinaryVector)superPosition).tallyVotes();
            }
            Vector additionalVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
            for (int x = 0; x < superpositions; ++x) {
                if (x % 100 == 0) {
                    System.err.print("...");
                }
                double overlapWithOrigin = superPosition.measureOverlap(originalVector);
                Vector randomVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
                double overlapWithRandom = superPosition.measureOverlap(randomVector);
                overlapscore += overlapWithRandom;
                overlapScore.add(overlapWithRandom);
                if (overlapWithRandom >= overlapWithOrigin) {
                    System.out.println("Iteration " + cnt + ": Incidental overlap occurred at superposition number " + x);
                    min = Math.min(min, x);
                    max = Math.max(max, x);
                    ++overlapcnt;
                    overlaprank += x;
                    overlapRank.add(Double.valueOf(x));
                    x = 999999999;
                }
                additionalVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
                superPosition.superpose(additionalVector, 1.0, null);
                if (flagConfig.vectortype() != VectorType.BINARY) continue;
                ((BinaryVector)superPosition).tallyVotes();
            }
        }
        double stdRank = SemanticVectorCollider.calculateSTD(overlapRank, (double)overlaprank / (double)overlapcnt);
        System.out.println("Collisions occurred in " + 100.0 * ((double)overlapcnt / (double)iterations) + "% of iterations");
        System.out.println("\nAverage collision rank " + (double)overlaprank / (double)overlapcnt);
        System.out.println("STD collision rank " + stdRank);
        System.out.println("Minimum collision rank " + min);
        System.out.println("Maximum collision rank " + max);
    }

    public static double calculateSTD(ArrayList<Double> values, double mean) {
        double std = 0.0;
        for (Double value : values) {
            std += Math.pow(value - mean, 2.0);
        }
        std = std / (double)values.size() - 1.0;
        std = Math.sqrt(std);
        return std;
    }
}

