/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfcomplex.FComplex;
import java.util.List;
import java.util.logging.Logger;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;

public class RealVectorUtils {
    private static final Logger logger = Logger.getLogger(RealVectorUtils.class.getCanonicalName());

    public static boolean orthogonalizeVectors(List<Vector> list) {
        int dimension = list.get(0).getDimension();
        for (int k = 0; k < list.size(); ++k) {
            Vector kthVector = list.get(k);
            if (kthVector.getVectorType() != VectorType.REAL) {
                throw new IncompatibleVectorsException();
            }
            kthVector.normalize();
            if (kthVector.getDimension() != dimension) {
                logger.warning("In orthogonalizeVector: not all vectors have required dimension.");
                return false;
            }
            for (int j = 0; j < k; ++j) {
                Vector jthVector = list.get(j);
                double dotProduct = kthVector.measureOverlap(jthVector);
                kthVector.superpose(jthVector, -dotProduct, null);
                kthVector.normalize();
            }
        }
        return true;
    }

    public static RealVector fftConvolution(RealVector first, RealVector second) {
        IncompatibleVectorsException.checkVectorsCompatible(first, second);
        DenseFloatMatrix1D coltVec1 = new DenseFloatMatrix1D(first.getCoordinates());
        DenseFloatMatrix1D coltVec2 = new DenseFloatMatrix1D(second.getCoordinates());
        int dimension = first.getDimension();
        DenseFComplexMatrix1D fft1 = coltVec1.getFft();
        DenseFComplexMatrix1D fft2 = coltVec2.getFft();
        for (int i = 0; i < dimension; ++i) {
            fft1.setQuick(i, FComplex.mult(fft1.getQuick(i), fft2.getQuick(i)));
        }
        fft1.ifft(true);
        DenseFloatMatrix1D coltResult = (DenseFloatMatrix1D)fft1.getRealPart();
        float[] coordinates = coltResult.elements();
        return new RealVector(coordinates);
    }

    public static RealVector normalizedConvolution(RealVector first, RealVector second) {
        RealVector first2 = first.copy();
        RealVector second2 = second.copy();
        first2.normalize();
        second2.normalize();
        RealVector convolution = RealVectorUtils.fftConvolution(first2, second2);
        convolution.normalize();
        return convolution;
    }

    public static double norm(RealVector vector) {
        double norm = 0.0;
        for (int d = 0; d < vector.getDimension(); ++d) {
            norm += Math.pow(vector.getCoordinates()[d], 2.0);
        }
        return Math.sqrt(norm);
    }

    public static RealVector getInvolution(RealVector vector) {
        vector.sparseToDense();
        float[] coordinates = vector.getCoordinates();
        int dimension = vector.getDimension();
        float[] involution = new float[dimension];
        involution[0] = coordinates[0];
        for (int i = 1; i < dimension; ++i) {
            involution[i] = coordinates[dimension - i];
        }
        return new RealVector(involution);
    }

    public static RealVector fftApproxInvConvolution(RealVector first, RealVector second) {
        return RealVectorUtils.fftConvolution(RealVectorUtils.getInvolution(first), second);
    }
}

