/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.PermutationUtils;
import pitt.search.semanticvectors.vectors.RealVectorUtils;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;

public class RealVector
implements Vector {
    public static RealBindMethod BIND_METHOD = RealBindMethod.NORMALIZEDCONVOLUTION;
    public static final Logger logger = Logger.getLogger(RealVector.class.getCanonicalName());
    private final int dimension;
    private float[] coordinates;
    private short[] sparseOffsets;
    private boolean isSparse;

    public static void setBindType(RealBindMethod bindMethod) {
        logger.info("Globally setting real vector BIND_METHOD to: '" + (Object)((Object)bindMethod) + "'");
        BIND_METHOD = bindMethod;
    }

    @Override
    public VectorType getVectorType() {
        return VectorType.REAL;
    }

    protected RealVector(int dimension) {
        this.dimension = dimension;
        this.sparseOffsets = new short[0];
        this.isSparse = true;
    }

    @Override
    public RealVector copy() {
        if (this.isSparse) {
            RealVector copy = new RealVector(this.dimension);
            copy.sparseOffsets = new short[this.sparseOffsets.length];
            System.arraycopy(this.sparseOffsets, 0, copy.sparseOffsets, 0, this.sparseOffsets.length);
            return copy;
        }
        float[] coordinatesCopy = new float[this.dimension];
        System.arraycopy(this.coordinates, 0, coordinatesCopy, 0, this.dimension);
        return new RealVector(coordinatesCopy);
    }

    @Override
    public String toString() {
        StringBuilder debugString = new StringBuilder("RealVector.");
        if (this.isSparse) {
            debugString.append("  Sparse.  Offsets are:\n");
            for (short sparseOffset : this.sparseOffsets) {
                debugString.append(sparseOffset).append(" ");
            }
        } else {
            debugString.append("  Dense.  Coordinates are:\n");
            for (float coordinate : this.coordinates) {
                debugString.append(coordinate).append(" ");
            }
        }
        debugString.append("\n");
        return debugString.toString();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public RealVector createZeroVector(int dimension) {
        return new RealVector(dimension);
    }

    @Override
    public boolean isZeroVector() {
        if (this.isSparse) {
            return this.sparseOffsets.length == 0;
        }
        for (float coordinate : this.coordinates) {
            if (coordinate == 0.0f) continue;
            return false;
        }
        return true;
    }

    @Override
    public RealVector generateRandomVector(int dimension, int seedLength, Random random) {
        int testPlace;
        RealVector randomVector = new RealVector(dimension);
        if (seedLength == dimension) {
            return this.generateDenseRandomVector(dimension, seedLength, random);
        }
        boolean[] occupiedPositions = new boolean[dimension];
        randomVector.sparseOffsets = new short[seedLength];
        int entryCount = 0;
        while (entryCount < seedLength / 2) {
            testPlace = random.nextInt(dimension);
            if (occupiedPositions[testPlace]) continue;
            occupiedPositions[testPlace] = true;
            randomVector.sparseOffsets[entryCount] = new Integer(testPlace + 1).shortValue();
            ++entryCount;
        }
        while (entryCount < seedLength) {
            testPlace = random.nextInt(dimension);
            if (occupiedPositions[testPlace]) continue;
            occupiedPositions[testPlace] = true;
            randomVector.sparseOffsets[entryCount] = new Integer((1 + testPlace) * -1).shortValue();
            ++entryCount;
        }
        return randomVector;
    }

    public RealVector generateDenseRandomVector(int dimension, int seedLength, Random random) {
        RealVector randomVector = new RealVector(dimension);
        randomVector.sparseToDense();
        for (int q = 0; q < dimension; ++q) {
            randomVector.coordinates[q] = (float)((double)random.nextFloat() - 0.5) / (float)dimension;
        }
        return randomVector;
    }

    @Override
    public double measureOverlap(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        if (this.isZeroVector()) {
            return 0.0;
        }
        RealVector realOther = (RealVector)other;
        if (realOther.isZeroVector()) {
            return 0.0;
        }
        if (this.isSparse) {
            this.sparseToDense();
        }
        if (realOther.isSparse) {
            realOther.sparseToDense();
        }
        double result = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            result += (double)(this.coordinates[i] * realOther.coordinates[i]);
            norm1 += (double)(this.coordinates[i] * this.coordinates[i]);
            norm2 += (double)(realOther.coordinates[i] * realOther.coordinates[i]);
        }
        return result / Math.sqrt(norm1 * norm2);
    }

    @Override
    public void superpose(Vector other, double weight, int[] permutation) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        RealVector realOther = (RealVector)other;
        if (this.isSparse) {
            this.sparseToDense();
        }
        if (realOther.isSparse) {
            for (int i = 0; i < realOther.sparseOffsets.length; ++i) {
                int entry = Integer.signum(realOther.sparseOffsets[i]);
                int positionToAdd = Math.abs(realOther.sparseOffsets[i]) - 1;
                if (permutation != null) {
                    positionToAdd = permutation[positionToAdd];
                }
                int n = positionToAdd;
                this.coordinates[n] = (float)((double)this.coordinates[n] + (double)entry * weight);
            }
        } else {
            int i;
            boolean anyNans = false;
            for (i = 0; i < this.dimension; ++i) {
                if (!Float.isNaN(realOther.coordinates[i])) continue;
                anyNans = true;
                break;
            }
            if (anyNans) {
                return;
            }
            for (i = 0; i < this.dimension; ++i) {
                int positionToAdd = i;
                if (permutation != null) {
                    positionToAdd = permutation[positionToAdd];
                }
                int n = positionToAdd;
                this.coordinates[n] = (float)((double)this.coordinates[n] + (double)realOther.coordinates[i] * weight);
            }
        }
    }

    @Override
    public void bind(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        RealVector realOther = (RealVector)other;
        if (this.isSparse) {
            this.sparseToDense();
        }
        switch (BIND_METHOD) {
            case PERMUTATION: {
                this.bindWithPermutation(realOther);
                return;
            }
            case CONVOLUTION: {
                this.bindWithConvolution(realOther, false);
                return;
            }
            case NORMALIZEDCONVOLUTION: {
                this.bindWithConvolution(realOther, true);
            }
        }
    }

    @Override
    public void release(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        RealVector realOther = (RealVector)other;
        if (this.isSparse) {
            this.sparseToDense();
        }
        switch (BIND_METHOD) {
            case PERMUTATION: {
                this.releaseWithPermutation(realOther);
                return;
            }
            case CONVOLUTION: 
            case NORMALIZEDCONVOLUTION: {
                this.releaseWithConvolution(realOther);
            }
        }
    }

    public void bindWithConvolution(RealVector realOther, boolean normalizeFirst) {
        RealVector result = null;
        result = normalizeFirst ? RealVectorUtils.normalizedConvolution(this, realOther) : RealVectorUtils.fftConvolution(this, realOther);
        this.coordinates = result.coordinates;
    }

    public void releaseWithConvolution(RealVector other) {
        RealVector result = RealVectorUtils.fftApproxInvConvolution(other, this);
        this.coordinates = result.coordinates;
    }

    public void bindWithPermutation(RealVector other) {
        RealVector result = this.createZeroVector(this.dimension);
        result.superpose(other, 1.0, PermutationUtils.getShiftPermutation(VectorType.REAL, this.dimension, 1));
        result.superpose(this, 1.0, PermutationUtils.getShiftPermutation(VectorType.REAL, this.dimension, -1));
        this.coordinates = result.coordinates;
    }

    public void releaseWithPermutation(RealVector other) {
        RealVector result = this.createZeroVector(this.dimension);
        this.superpose(other, -1.0, PermutationUtils.getShiftPermutation(VectorType.REAL, this.dimension, 1));
        result.superpose(this, 1.0, PermutationUtils.getShiftPermutation(VectorType.REAL, this.dimension, 1));
        this.coordinates = result.coordinates;
    }

    @Override
    public void normalize() {
        if (this.isSparse) {
            this.sparseToDense();
        }
        double normSq = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            normSq += (double)(this.coordinates[i] * this.coordinates[i]);
        }
        float norm = (float)Math.sqrt(normSq);
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = this.coordinates[i] / norm;
        }
    }

    @Override
    public void writeToLuceneStream(IndexOutput outputStream) {
        float[] coordsToWrite;
        if (this.isSparse) {
            RealVector copy = this.copy();
            copy.sparseToDense();
            coordsToWrite = copy.coordinates;
        } else {
            coordsToWrite = this.coordinates;
        }
        for (int i = 0; i < this.dimension; ++i) {
            try {
                outputStream.writeInt(Float.floatToIntBits(coordsToWrite[i]));
                continue;
            }
            catch (ClosedByInterruptException e) {
                throw new QueryInterruptedException("Transaction was aborted by the user");
            }
            catch (IOException e) {
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void writeToLuceneStream(IndexOutput outputStream, int k) {
        float[] coordsToWrite;
        if (this.isSparse) {
            RealVector copy = this.copy();
            copy.sparseToDense();
            coordsToWrite = copy.coordinates;
        } else {
            coordsToWrite = this.coordinates;
        }
        for (int i = 0; i < k; ++i) {
            try {
                outputStream.writeInt(Float.floatToIntBits(coordsToWrite[i]));
                continue;
            }
            catch (ClosedByInterruptException e) {
                throw new QueryInterruptedException("Transaction was aborted by the user");
            }
            catch (IOException e) {
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void readFromLuceneStream(IndexInput inputStream) {
        if (this.isSparse) {
            this.coordinates = new float[this.dimension];
            this.sparseOffsets = null;
            this.isSparse = false;
        }
        for (int i = 0; i < this.dimension; ++i) {
            try {
                this.coordinates[i] = Float.intBitsToFloat(inputStream.readInt());
                continue;
            }
            catch (IOException e) {
                logger.severe("Failed to parse vector from Lucene stream.  This signifies a programming or runtime error, e.g., a dimension mismatch.");
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void readFromByteBuffer(ByteBuffer byteBuffer) {
        if (this.isSparse) {
            this.coordinates = new float[this.dimension];
            this.sparseOffsets = null;
            this.isSparse = false;
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = Float.intBitsToFloat(byteBuffer.getInt());
        }
    }

    @Override
    public String writeToString() {
        StringBuilder builder = new StringBuilder();
        float[] denseCoordinates = this.getCoordinates();
        for (int i = 0; i < this.dimension; ++i) {
            builder.append(Float.toString(denseCoordinates[i]));
            if (i == this.dimension - 1) continue;
            builder.append("|");
        }
        return builder.toString();
    }

    @Override
    public void readFromString(String input) {
        String[] entries = input.split("\\|");
        if (entries.length != this.dimension) {
            throw new IllegalArgumentException("Found " + entries.length + " possible coordinates: expected " + this.dimension);
        }
        if (this.isSparse) {
            this.coordinates = new float[this.dimension];
            this.sparseOffsets = null;
            this.isSparse = false;
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = Float.parseFloat(entries[i]);
        }
    }

    protected void sparseToDense() {
        int i;
        if (!this.isSparse) {
            return;
        }
        this.coordinates = new float[this.dimension];
        for (i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = 0.0f;
        }
        for (i = 0; i < this.sparseOffsets.length; ++i) {
            this.coordinates[Math.abs((int)this.sparseOffsets[i]) - 1] = Math.signum(this.sparseOffsets[i]);
        }
        this.isSparse = false;
    }

    public float[] getCoordinates() {
        if (this.isSparse) {
            RealVector copy = this.copy();
            copy.sparseToDense();
            return copy.coordinates;
        }
        return this.coordinates;
    }

    public RealVector(float[] coordinates) {
        this.dimension = coordinates.length;
        this.coordinates = coordinates;
    }

    public RealVector(int dimension, short[] sparseOffsets) {
        this.isSparse = true;
        this.dimension = dimension;
        short[] sArray = sparseOffsets;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short offset = sArray[i];
            if (offset != 0 && offset <= dimension && offset >= -1 * dimension) continue;
            throw new IllegalArgumentException("Offsets too large for dimension!");
        }
        this.sparseOffsets = sparseOffsets;
    }

    public static enum RealBindMethod {
        PERMUTATION,
        CONVOLUTION,
        NORMALIZEDCONVOLUTION;

    }
}

