/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.PermutationUtils;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;

public class PermutationVector
implements Vector {
    public static RealBindMethod BIND_METHOD = RealBindMethod.NORMALIZEDCONVOLUTION;
    public static final Logger logger = Logger.getLogger(PermutationVector.class.getCanonicalName());
    private final int dimension;
    private int[] coordinates;

    public static void setBindType(RealBindMethod bindMethod) {
        logger.info("Globally setting real vector BIND_METHOD to: '" + (Object)((Object)bindMethod) + "'");
        BIND_METHOD = bindMethod;
    }

    @Override
    public VectorType getVectorType() {
        return VectorType.REAL;
    }

    protected PermutationVector(int dimension) {
        this.dimension = dimension;
        this.coordinates = new int[dimension];
    }

    public PermutationVector(int[] permutation) {
        this.dimension = permutation.length;
        this.coordinates = permutation;
    }

    @Override
    public PermutationVector copy() {
        int[] coordinatesCopy = new int[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            coordinatesCopy[i] = this.coordinates[i];
        }
        return new PermutationVector(coordinatesCopy);
    }

    @Override
    public String toString() {
        StringBuilder debugString = new StringBuilder("RealVector.");
        debugString.append("   Permutations are:\n");
        int[] nArray = this.coordinates;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float coordinate = nArray[i];
            debugString.append(coordinate + " ");
        }
        debugString.append("\n");
        return debugString.toString();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public PermutationVector createZeroVector(int dimension) {
        return new PermutationVector(dimension);
    }

    @Override
    public boolean isZeroVector() {
        for (int coordinate : this.coordinates) {
            if (coordinate == 0) continue;
            return false;
        }
        return true;
    }

    public PermutationVector generateRandomVector(int dimension) {
        return new PermutationVector(PermutationUtils.getRandomPermutation(this.getVectorType(), dimension));
    }

    public PermutationVector generateRandomVector(int dimension, Random random) {
        return new PermutationVector(PermutationUtils.getRandomPermutation(this.getVectorType(), dimension, random));
    }

    @Override
    public double measureOverlap(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        if (this.isZeroVector()) {
            return 0.0;
        }
        PermutationVector integerOther = (PermutationVector)other;
        if (integerOther.isZeroVector()) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            if (this.coordinates[i] != integerOther.getCoordinates()[i]) continue;
            result += 1.0;
        }
        return result / (double)this.dimension;
    }

    @Override
    public void superpose(Vector other, double weight, int[] permutation) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        PermutationVector integerOther = (PermutationVector)other;
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = (this.coordinates[i] + integerOther.coordinates[i]) % this.dimension;
        }
    }

    @Override
    public void bind(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        PermutationVector integerOther = (PermutationVector)other;
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = this.coordinates[i] * integerOther.coordinates[i] % this.dimension;
        }
    }

    @Override
    public void release(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        PermutationVector integerOther = (PermutationVector)other;
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = this.coordinates[i] / integerOther.coordinates[i] % this.dimension;
        }
    }

    @Override
    public void normalize() {
    }

    @Override
    public void writeToLuceneStream(IndexOutput outputStream) {
        int[] coordsToWrite = this.coordinates;
        for (int i = 0; i < this.dimension; ++i) {
            try {
                outputStream.writeInt(coordsToWrite[i]);
                continue;
            }
            catch (ClosedByInterruptException e) {
                throw new QueryInterruptedException("Transaction was aborted by the user");
            }
            catch (IOException e) {
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void readFromLuceneStream(IndexInput inputStream) {
        for (int i = 0; i < this.dimension; ++i) {
            try {
                this.coordinates[i] = inputStream.readInt();
                continue;
            }
            catch (IOException e) {
                logger.severe("Failed to parse vector from Lucene stream.  This signifies a programming or runtime error, e.g., a dimension mismatch.");
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void readFromByteBuffer(ByteBuffer byteBuffer) {
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = byteBuffer.getInt();
        }
    }

    @Override
    public String writeToString() {
        StringBuilder builder = new StringBuilder();
        int[] denseCoordinates = this.getCoordinates();
        for (int i = 0; i < this.dimension; ++i) {
            builder.append(denseCoordinates[i]);
            if (i == this.dimension - 1) continue;
            builder.append("|");
        }
        return builder.toString();
    }

    @Override
    public void readFromString(String input) {
        String[] entries = input.split("\\|");
        if (entries.length != this.dimension) {
            throw new IllegalArgumentException("Found " + entries.length + " possible coordinates: expected " + this.dimension);
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.coordinates[i] = Integer.parseInt(entries[i]);
        }
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public Vector generateRandomVector(int dimension, int numEntries, Random random) {
        return this.generateRandomVector(dimension);
    }

    @Override
    public void writeToLuceneStream(IndexOutput outputStream, int k) {
        this.writeToLuceneStream(outputStream);
    }

    public static enum RealBindMethod {
        PERMUTATION,
        CONVOLUTION,
        NORMALIZEDCONVOLUTION;

    }
}

