/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import pitt.search.semanticvectors.vectors.VectorType;

public class PermutationUtils {
    private PermutationUtils() {
    }

    public static int getPermutationLength(VectorType vectorType, int dimension) {
        return vectorType != VectorType.BINARY ? dimension : dimension / 64;
    }

    public static int[] getShiftPermutation(VectorType vectorType, int dimension, int shift) {
        if (vectorType.equals((Object)VectorType.COMPLEX) && shift % 2 != 0) {
            shift = (int)((float)shift + Math.signum(shift));
        }
        int permutationLength = PermutationUtils.getPermutationLength(vectorType, dimension);
        int[] permutation = new int[permutationLength];
        for (int i = 0; i < permutationLength; ++i) {
            int entry = (i + shift) % permutationLength;
            if (entry < 0) {
                entry += permutationLength;
            }
            permutation[i] = entry;
        }
        return permutation;
    }

    public static int[] getSwapPermutation(VectorType vectorType, int dimension, double swaps) {
        int permutationLength = PermutationUtils.getPermutationLength(vectorType, dimension);
        int[] permutation = new int[permutationLength];
        int numswaps = (int)Math.floor(swaps * (double)permutationLength);
        System.out.println(numswaps + "\t" + permutationLength);
        for (int i = 0; i < numswaps && i < permutationLength - 4; i += 4) {
            permutation[i] = i + 2;
            permutation[i + 2] = i;
            permutation[i + 1] = i + 3;
            permutation[i + 3] = i + 1;
        }
        return permutation;
    }

    public static int[] getSwapPermutation(VectorType vectorType, int[] permutation, double swaps) {
        int numswaps = (int)Math.floor(swaps * (double)permutation.length);
        System.out.println("Numswaps " + numswaps);
        int[] nupermutation = new int[permutation.length];
        ArrayList<Integer> allSwaps = new ArrayList<Integer>();
        for (int q = 0; q < permutation.length; ++q) {
            allSwaps.add(q);
            nupermutation[q] = permutation[q];
        }
        Collections.shuffle(allSwaps);
        for (int r = 0; r < numswaps; r += 2) {
            nupermutation[((Integer)allSwaps.get((int)r)).intValue()] = permutation[(Integer)allSwaps.get(r + 1)];
            nupermutation[((Integer)allSwaps.get((int)(r + 1))).intValue()] = permutation[(Integer)allSwaps.get(r)];
        }
        return nupermutation;
    }

    public static int[] getRandomPermutation(VectorType vectorType, int dimension) {
        return PermutationUtils.getRandomPermutation(vectorType, dimension, null);
    }

    public static int[] getRandomPermutation(VectorType vectorType, int dimension, Random random) {
        int i;
        int permutationLength = PermutationUtils.getPermutationLength(vectorType, dimension);
        int[] permutation = new int[permutationLength];
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (i = 0; i < permutationLength; ++i) {
            positions.add(i);
        }
        if (random == null) {
            Collections.shuffle(positions);
        } else {
            Collections.shuffle(positions, random);
        }
        for (i = 0; i < permutationLength; ++i) {
            permutation[i] = (Integer)positions.get(i);
        }
        return permutation;
    }

    public static int[] getInversePermutation(int[] permutation) {
        int[] inversePermutation = new int[permutation.length];
        for (int x = 0; x < permutation.length; ++x) {
            inversePermutation[permutation[x]] = x;
        }
        return inversePermutation;
    }
}

