/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import pitt.search.semanticvectors.vectors.Vector;

public class IncompatibleVectorsException
extends RuntimeException {
    public IncompatibleVectorsException() {
    }

    public IncompatibleVectorsException(String message) {
        super(message + "\nThis almost certainly indicates a programming error!");
    }

    public static void checkVectorsCompatible(Vector first, Vector second) {
        if (first == null) {
            throw new NullPointerException("first vector cannot be null");
        }
        if (second == null) {
            throw new NullPointerException("second vector cannot be null");
        }
        if (first.getClass() != second.getClass()) {
            throw new IncompatibleVectorsException("Trying to combine vectors of type: " + first.getClass().getCanonicalName() + ", " + second.getClass().getCanonicalName());
        }
        if (first.getDimension() != second.getDimension()) {
            throw new IncompatibleVectorsException("Trying to combine vectors of dimension: " + first.getDimension() + ", " + second.getDimension());
        }
    }
}

