/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import pitt.search.semanticvectors.vectors.CircleLookupTable;
import pitt.search.semanticvectors.vectors.ComplexVector;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;

public class ComplexVectorUtils {
    public static final Logger logger = Logger.getLogger(RealVector.class.getCanonicalName());

    public static void superposeWithAngle(ComplexVector vec1, ComplexVector vec2) {
        int dim = vec1.getDimension();
        assert (dim == vec2.getDimension());
        assert (vec1.getOpMode() == ComplexVector.Mode.CARTESIAN || vec1.getOpMode() == ComplexVector.Mode.HERMITIAN);
        assert (vec2.getOpMode() == ComplexVector.Mode.POLAR_DENSE);
        short[] c = vec2.getPhaseAngles();
        float[] coordinates = vec1.getCoordinates();
        int i = 0;
        int j = 0;
        while (i < dim) {
            int n = j;
            coordinates[n] = coordinates[n] + CircleLookupTable.getRealEntry(c[i]);
            int n2 = j + 1;
            coordinates[n2] = coordinates[n2] + CircleLookupTable.getImagEntry(c[i]);
            ++i;
            j += 2;
        }
    }

    public static void superposeWithAngle(ComplexVector vec1, ComplexVector vec2, float weight, int[] permutation) {
        int dim = vec1.getDimension();
        short[] c = vec2.getPhaseAngles();
        float[] coordinates = vec1.getCoordinates();
        if (permutation != null) {
            for (int i = 0; i < dim; ++i) {
                int positionToAdd;
                int n = positionToAdd = permutation[i] << 1;
                coordinates[n] = coordinates[n] + CircleLookupTable.getRealEntry(c[i]) * weight;
                int n2 = positionToAdd + 1;
                coordinates[n2] = coordinates[n2] + CircleLookupTable.getImagEntry(c[i]) * weight;
            }
        } else {
            for (int i = 0; i < dim; ++i) {
                int positionToAdd;
                int n = positionToAdd = i << 1;
                coordinates[n] = coordinates[n] + CircleLookupTable.getRealEntry(c[i]) * weight;
                int n3 = positionToAdd + 1;
                coordinates[n3] = coordinates[n3] + CircleLookupTable.getImagEntry(c[i]) * weight;
            }
        }
    }

    public static void superposeWithSparseAngle(ComplexVector vec1, ComplexVector vec2, float weight, int[] permutation) {
        assert (vec1.getOpMode() == ComplexVector.Mode.CARTESIAN || vec1.getOpMode() == ComplexVector.Mode.HERMITIAN);
        assert (vec2.getOpMode() == ComplexVector.Mode.POLAR_SPARSE);
        short[] offsets = vec2.getSparseOffsets();
        float[] coordinates = vec1.getCoordinates();
        for (int i = 0; i < offsets.length; i += 2) {
            int positionToAdd = offsets[i] << 1;
            if (permutation != null) {
                positionToAdd = permutation[offsets[i]] << 1;
            }
            int phaseAngleIdx = i + 1;
            int n = positionToAdd;
            coordinates[n] = coordinates[n] + CircleLookupTable.getRealEntry(offsets[phaseAngleIdx]) * weight;
            int n2 = positionToAdd + 1;
            coordinates[n2] = coordinates[n2] + CircleLookupTable.getImagEntry(offsets[phaseAngleIdx]) * weight;
        }
    }

    public static void superposeWithCoord(ComplexVector vec1, ComplexVector vec2) {
        int arrayDim = vec1.getDimension() * 2;
        IncompatibleVectorsException.checkVectorsCompatible(vec1, vec2);
        assert (vec1.getOpMode() == ComplexVector.Mode.CARTESIAN || vec1.getOpMode() == ComplexVector.Mode.HERMITIAN);
        assert (vec2.getOpMode() == ComplexVector.Mode.CARTESIAN || vec2.getOpMode() == ComplexVector.Mode.HERMITIAN);
        float[] coordinates1 = vec1.getCoordinates();
        float[] coordinates2 = vec2.getCoordinates();
        for (int i = 0; i < arrayDim; ++i) {
            int n = i;
            coordinates1[n] = coordinates1[n] + coordinates2[i];
        }
    }

    public static void superposeWithCoord(ComplexVector vec1, ComplexVector vec2, float weight, int[] permutation) {
        IncompatibleVectorsException.checkVectorsCompatible(vec1, vec2);
        assert (vec1.getOpMode() == ComplexVector.Mode.CARTESIAN || vec1.getOpMode() == ComplexVector.Mode.HERMITIAN);
        assert (vec2.getOpMode() == ComplexVector.Mode.CARTESIAN || vec2.getOpMode() == ComplexVector.Mode.HERMITIAN);
        float[] coordinates1 = vec1.getCoordinates();
        float[] coordinates2 = vec2.getCoordinates();
        for (int i = 0; i < vec1.getDimension(); ++i) {
            int positionToAdd = permutation == null ? i : permutation[i];
            int n = 2 * positionToAdd;
            coordinates1[n] = coordinates1[n] + coordinates2[2 * i] * weight;
            int n2 = 2 * positionToAdd + 1;
            coordinates1[n2] = coordinates1[n2] + coordinates2[2 * i + 1] * weight;
        }
    }

    public static boolean orthogonalizeVectors(List<Vector> list) {
        int dimension = list.get(0).getDimension();
        for (int k = 0; k < list.size(); ++k) {
            Vector kthVector = list.get(k);
            kthVector.normalize();
            if (kthVector.getDimension() != dimension) {
                logger.warning("In orthogonalizeVector: not all vectors have required dimension.");
                return false;
            }
            for (int j = 0; j < k; ++j) {
                Vector jthVector = list.get(j);
                ComplexVectorUtils.renderOrthogonal((ComplexVector)kthVector, (ComplexVector)jthVector);
            }
            kthVector.normalize();
        }
        return true;
    }

    public static void renderOrthogonal(ComplexVector vec1, ComplexVector vec2) {
        IncompatibleVectorsException.checkVectorsCompatible(vec1, vec2);
        if (vec1.getOpMode() != ComplexVector.Mode.CARTESIAN) {
            vec1.toCartesian();
        }
        if (vec2.getOpMode() != ComplexVector.Mode.CARTESIAN) {
            vec2.toCartesian();
        }
        float[] coordinates1 = vec1.getCoordinates();
        float[] coordinates2 = vec2.getCoordinates();
        double cosine = vec1.measureHermitianOverlap(vec2);
        for (int i = 0; i < coordinates1.length; ++i) {
            coordinates1[i] = (float)((double)coordinates1[i] - cosine * (double)coordinates2[i]);
        }
    }

    public static void renderPairwiseOrthogonal(ComplexVector vec1, ComplexVector vec2) {
        IncompatibleVectorsException.checkVectorsCompatible(vec1, vec2);
        if (vec1.getOpMode() != ComplexVector.Mode.CARTESIAN) {
            vec1.toCartesian();
        }
        if (vec2.getOpMode() != ComplexVector.Mode.CARTESIAN) {
            vec2.toCartesian();
        }
        float[] coordinates1 = vec1.getCoordinates();
        float[] coordinates2 = vec2.getCoordinates();
        for (int i = 0; i < vec1.getDimension() * 2; i += 2) {
            double resultThisPair = coordinates1[i] * coordinates2[i];
            resultThisPair += (double)(coordinates1[i + 1] * coordinates2[i + 1]);
            double norm1 = coordinates1[i] * coordinates1[i];
            norm1 += (double)(coordinates1[i + 1] * coordinates1[i + 1]);
            double norm2 = coordinates2[i] * coordinates2[i];
            norm2 += (double)(coordinates2[i + 1] * coordinates2[i + 1]);
            norm1 = Math.sqrt(norm1);
            norm2 = Math.sqrt(norm2);
            double cosine = 0.0;
            if (norm1 > 0.0 && norm2 > 0.0) {
                cosine = resultThisPair / (norm1 * norm2);
            }
            coordinates1[i] = (float)((double)coordinates1[i] - cosine * (double)coordinates2[i]);
            coordinates1[i + 1] = (float)((double)coordinates1[i + 1] - cosine * (double)coordinates2[i + 1]);
        }
    }

    public static void setFloatArrayToZero(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0.0f;
        }
    }

    public static void scaleFloatArray(float[] array, float weight) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i] * weight;
        }
    }

    public static Vector generateHermitianRandomVector(int dimension, int seedlength, Random random) {
        return null;
    }
}

