/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.FixedBitSet;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import pitt.search.semanticvectors.vectors.BinaryVectorUtils;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.PermutationUtils;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;

public class BinaryVector
implements Vector {
    public static BinaryNormalizationMethod NORMALIZE_METHOD = BinaryNormalizationMethod.SPATTERCODE;
    public static final Logger logger = Logger.getLogger(BinaryVector.class.getCanonicalName());
    public static final int BINARY_VECTOR_DECIMAL_PLACES = 2;
    public static final boolean BINARY_BINDING_WITH_PERMUTE = false;
    private static int DEBUG_PRINT_LENGTH = 64;
    private Random random;
    private final int dimension;
    protected FixedBitSet bitSet;
    private boolean isSparse;
    private AtomicBoolean unTallied = new AtomicBoolean(true);
    private ArrayList<FixedBitSet> votingRecord;
    AtomicInteger totalNumberOfVotes = new AtomicInteger(0);
    int minimum = 0;
    private FixedBitSet tempSet;

    public static void setNormalizationMethod(BinaryNormalizationMethod normalizationMethod) {
        logger.info("Globally setting binary vector NORMALIZATION_METHOD to: '" + (Object)((Object)normalizationMethod) + "'");
        NORMALIZE_METHOD = normalizationMethod;
    }

    @Override
    public VectorType getVectorType() {
        return VectorType.BINARY;
    }

    public BinaryVector(int dimension) {
        if (dimension % 64 != 0) {
            throw new IllegalArgumentException("Dimension should be a multiple of 64: " + dimension + " will lead to trouble!");
        }
        this.dimension = dimension;
        this.bitSet = new FixedBitSet(dimension);
        this.isSparse = true;
        this.random = new Random();
    }

    @Override
    public BinaryVector copy() {
        BinaryVector copy = new BinaryVector(this.dimension);
        copy.bitSet = this.bitSet.clone();
        if (!this.isSparse) {
            copy.votingRecord = (ArrayList)this.votingRecord.clone();
        }
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder debugString = new StringBuilder("");
        if (this.isSparse) {
            debugString.append("  Sparse.  First " + DEBUG_PRINT_LENGTH + " values are:\n");
            for (int x = 0; x < DEBUG_PRINT_LENGTH; ++x) {
                debugString.append(this.bitSet.get(x) ? "1 " : "0 ");
            }
            debugString.append("\nCardinality " + this.bitSet.cardinality() + "\n");
        } else {
            int x;
            debugString.append("  Dense.  First " + DEBUG_PRINT_LENGTH + " values are:\n");
            for (int x2 = 0; x2 < DEBUG_PRINT_LENGTH; ++x2) {
                debugString.append(this.bitSet.get(x2) ? "1" : "0");
            }
            debugString.append("\nVOTING RECORD: \n");
            for (int y = 0; y < this.votingRecord.size(); ++y) {
                for (x = 0; x < DEBUG_PRINT_LENGTH; ++x) {
                    debugString.append(this.votingRecord.get(y).get(x) ? "1 " : "0 ");
                }
                debugString.append("\n");
            }
            double[] actualvals = new double[DEBUG_PRINT_LENGTH];
            debugString.append("COUNTS    : ");
            for (x = 0; x < this.votingRecord.size(); ++x) {
                for (int y = 0; y < DEBUG_PRINT_LENGTH; ++y) {
                    if (!this.votingRecord.get(x).get(y)) continue;
                    int n = y;
                    actualvals[n] = actualvals[n] + Math.pow(2.0, x);
                }
            }
            for (x = 0; x < DEBUG_PRINT_LENGTH; ++x) {
                debugString.append((int)(((double)this.minimum + actualvals[x]) / Math.pow(10.0, 2.0)) + " ");
            }
            debugString.append("\nNORMALIZED: ");
            this.normalize();
            for (x = 0; x < DEBUG_PRINT_LENGTH; ++x) {
                debugString.append(this.bitSet.get(x) + " ");
            }
            debugString.append("\n");
            debugString.append("\nCardinality " + this.bitSet.cardinality() + "\n");
            debugString.append("Votes " + this.totalNumberOfVotes + "\n");
            debugString.append("Minimum " + this.minimum + "\n");
            debugString.append("\n");
        }
        return debugString.toString();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public BinaryVector createZeroVector(int dimension) {
        if (dimension % 64 != 0) {
            logger.severe("Dimension should be a multiple of 64: " + dimension + " will lead to trouble!");
        }
        return new BinaryVector(dimension);
    }

    @Override
    public boolean isZeroVector() {
        if (this.isSparse) {
            return this.bitSet.cardinality() == 0;
        }
        return this.votingRecord == null || this.votingRecord.size() == 0 || this.votingRecord.size() == 1 && this.votingRecord.get(0).cardinality() == 0;
    }

    @Override
    public BinaryVector generateRandomVector(int dimension, int numEntries, Random random) {
        if (dimension % 64 != 0) {
            throw new IllegalArgumentException("Dimension should be a multiple of 64: " + dimension + " will lead to trouble!");
        }
        if (numEntries != dimension / 2) {
            logger.severe("Attempting to create binary vector with unequal number of zeros and ones. Unlikely to produce meaningful results. Therefore, seedlength has been set to  dimension/2, as recommended for binary vectors");
            numEntries = dimension / 2;
        }
        BinaryVector randomVector = new BinaryVector(dimension);
        randomVector.bitSet = new FixedBitSet(dimension);
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        for (int q = 0; q < dimension; ++q) {
            dimensions.add(q);
        }
        Collections.shuffle(dimensions, random);
        for (int r = 0; r < numEntries; ++r) {
            int testPlace = (Integer)dimensions.get(r);
            randomVector.bitSet.set(testPlace);
        }
        return randomVector;
    }

    @Override
    public double measureOverlap(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        if (this.isZeroVector()) {
            return 0.0;
        }
        BinaryVector binaryOther = (BinaryVector)other;
        if (binaryOther.isZeroVector()) {
            return 0.0;
        }
        double hammingDistance = BinaryVectorUtils.xorCount(this.bitSet, binaryOther.bitSet);
        return 2.0 * (0.5 - hammingDistance / (double)this.dimension);
    }

    @Override
    public synchronized void superpose(Vector other, double weight, int[] permutation) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        if (weight == 0.0) {
            return;
        }
        if (other.isZeroVector()) {
            return;
        }
        BinaryVector binaryOther = (BinaryVector)other;
        boolean flippedBitSet = false;
        if (weight < 0.0) {
            weight = Math.abs(weight);
            binaryOther.bitSet.flip(0, binaryOther.getDimension());
            flippedBitSet = true;
        }
        if (this.isSparse) {
            this.elementalToSemantic();
        }
        if (permutation != null) {
            if (permutation.length != this.dimension / 64) {
                throw new IllegalArgumentException("Binary vector of dimension " + this.dimension + " must have permutation of length " + this.dimension / 64 + " not " + permutation.length);
            }
            BinaryVector temp = binaryOther.copy();
            temp.permute(permutation);
            this.superposeBitSet(temp.bitSet, weight);
        } else {
            this.superposeBitSet(binaryOther.bitSet, weight);
        }
        if (flippedBitSet) {
            binaryOther.bitSet.flip(0, binaryOther.getDimension());
        }
        this.unTallied.set(true);
    }

    protected synchronized void superposeBitSet(FixedBitSet incomingBitSet, double weight) {
        if ((weight = (double)((int)Math.round(weight * Math.pow(10.0, 2.0)))) == 0.0) {
            return;
        }
        this.totalNumberOfVotes.set(this.totalNumberOfVotes.get() + (int)weight);
        int logFloorOfWeight = (int)Math.floor(Math.log(weight) / Math.log(2.0));
        if (logFloorOfWeight < this.votingRecord.size() - 1) {
            while (logFloorOfWeight > 0) {
                this.superposeBitSetFromRowFloor(incomingBitSet, logFloorOfWeight);
                logFloorOfWeight = (int)Math.floor(Math.log(weight -= (double)((int)Math.pow(2.0, logFloorOfWeight))) / Math.log(2.0));
            }
        }
        int x = 0;
        while ((double)x < weight) {
            this.superposeBitSetFromRowFloor(incomingBitSet, 0);
            ++x;
        }
    }

    protected synchronized void superposeBitSetFromRowFloor(FixedBitSet incomingBitSet, int rowfloor) {
        int x;
        int max = this.getMaximumSharedWeight();
        if (max > 0) {
            this.decrement(max);
        }
        this.tempSet.xor(this.tempSet);
        this.tempSet.xor(incomingBitSet);
        for (x = rowfloor; x < this.votingRecord.size() && this.tempSet.cardinality() > 0; ++x) {
            this.tempSet.and(this.votingRecord.get(x));
        }
        if (this.tempSet.cardinality() > 0) {
            this.votingRecord.add(new FixedBitSet(this.dimension));
        }
        this.votingRecord.get(rowfloor).xor(incomingBitSet);
        this.tempSet.xor(this.tempSet);
        this.tempSet.xor(incomingBitSet);
        for (x = rowfloor + 1; x < this.votingRecord.size(); ++x) {
            this.tempSet.andNot(this.votingRecord.get(x - 1));
            this.votingRecord.get(x).xor(this.tempSet);
        }
    }

    public static String reverse(String str) {
        if (null == str || str.length() <= 1) {
            return str;
        }
        return new StringBuffer(str).reverse().toString();
    }

    private synchronized void setTempSetToExactMatches(int target) {
        if (target == 0) {
            this.tempSet.set(0, this.dimension);
            this.tempSet.xor(this.votingRecord.get(0));
            for (int x = 1; x < this.votingRecord.size(); ++x) {
                this.tempSet.andNot(this.votingRecord.get(x));
            }
        } else {
            String inbinary = BinaryVector.reverse(Integer.toBinaryString(target));
            this.tempSet.xor(this.tempSet);
            try {
                this.tempSet.xor(this.votingRecord.get(inbinary.indexOf("1")));
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
            for (int q = 0; q < this.votingRecord.size(); ++q) {
                if (q < inbinary.length() && inbinary.charAt(q) == '1') {
                    this.tempSet.and(this.votingRecord.get(q));
                    continue;
                }
                this.tempSet.andNot(this.votingRecord.get(q));
            }
        }
    }

    protected synchronized FixedBitSet concludeVote() {
        if (this.votingRecord.size() == 0 || this.votingRecord.size() == 1 && this.votingRecord.get(0).cardinality() == 0) {
            return new FixedBitSet(this.dimension);
        }
        return this.concludeVote(this.totalNumberOfVotes.get());
    }

    protected synchronized FixedBitSet concludeVote(int target) {
        int target2 = (int)Math.ceil((double)target / 2.0);
        if ((target2 -= this.minimum) < 0) {
            FixedBitSet ans = new FixedBitSet(this.dimension);
            ans.set(0, this.dimension);
            return ans;
        }
        boolean even = target % 2 == 0;
        FixedBitSet result = this.concludeVote(target2, this.votingRecord.size() - 1);
        if (even) {
            this.setTempSetToExactMatches(target2);
            boolean switcher = true;
            int q = this.tempSet.nextSetBit(0);
            while (q != Integer.MAX_VALUE) {
                boolean bl = switcher = !switcher;
                if (switcher) {
                    this.tempSet.clear(q);
                }
                q = this.tempSet.nextSetBit(q);
            }
            result.andNot(this.tempSet);
        }
        return result;
    }

    protected synchronized FixedBitSet concludeVote(int target, int row_ceiling) {
        if (target == 0) {
            FixedBitSet atLeastZero = new FixedBitSet(this.dimension);
            atLeastZero.set(0, this.dimension);
            return atLeastZero;
        }
        double rowfloor = Math.log(target) / Math.log(2.0);
        int row_floor = (int)Math.floor(rowfloor);
        int remainder = target - (int)Math.pow(2.0, row_floor);
        if (row_floor >= this.votingRecord.size()) {
            return new FixedBitSet(this.dimension);
        }
        if (row_ceiling == 0 && target == 1) {
            return this.votingRecord.get(0);
        }
        if (remainder == 0) {
            FixedBitSet definitePositives = new FixedBitSet(this.dimension);
            for (int q = row_floor; q <= row_ceiling; ++q) {
                definitePositives.or(this.votingRecord.get(q));
            }
            return definitePositives;
        }
        FixedBitSet definitePositives = new FixedBitSet(this.dimension);
        for (int q = row_floor + 1; q <= row_ceiling; ++q) {
            definitePositives.or(this.votingRecord.get(q));
        }
        FixedBitSet possiblePositives = this.votingRecord.get(row_floor).clone();
        FixedBitSet definitePositives2 = this.concludeVote(remainder, row_floor - 1);
        possiblePositives.and(definitePositives2);
        definitePositives.or(possiblePositives);
        return definitePositives;
    }

    public synchronized void decrement() {
        this.tempSet.set(0, this.dimension);
        for (int q = 0; q < this.votingRecord.size(); ++q) {
            this.votingRecord.get(q).xor(this.tempSet);
            this.tempSet.and(this.votingRecord.get(q));
        }
    }

    public synchronized void decrement(int weight) {
        if (weight == 0) {
            return;
        }
        this.minimum += weight;
        int logfloor = (int)Math.floor(Math.log(weight) / Math.log(2.0));
        if (logfloor < this.votingRecord.size() - 1) {
            while (logfloor > 0) {
                this.selectedDecrement(logfloor);
                logfloor = (int)Math.floor(Math.log(weight -= (int)Math.pow(2.0, logfloor)) / Math.log(2.0));
            }
        }
        for (int x = 0; x < weight; ++x) {
            this.decrement();
        }
    }

    public synchronized void selectedDecrement(int floor) {
        this.tempSet.set(0, this.dimension);
        for (int q = floor; q < this.votingRecord.size(); ++q) {
            this.votingRecord.get(q).xor(this.tempSet);
            this.tempSet.and(this.votingRecord.get(q));
        }
    }

    protected synchronized int getMaximumSharedWeight() {
        int thismaximum = 0;
        this.tempSet.xor(this.tempSet);
        for (int x = this.votingRecord.size() - 1; x >= 0; --x) {
            this.tempSet.or(this.votingRecord.get(x));
            if (this.tempSet.cardinality() != this.dimension) continue;
            thismaximum += (int)Math.pow(2.0, x);
            this.tempSet.xor(this.tempSet);
        }
        return thismaximum;
    }

    public void bind(Vector other, int direction) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        BinaryVector binaryOther = (BinaryVector)other.copy();
        if (direction > 0) {
            this.permute(PermutationUtils.getShiftPermutation(VectorType.BINARY, this.dimension, 1));
            this.bitSet.xor(binaryOther.bitSet);
        } else {
            this.bitSet.xor(binaryOther.bitSet);
            this.permute(PermutationUtils.getShiftPermutation(VectorType.BINARY, this.dimension, -1));
        }
    }

    public void release(Vector other, int direction) {
        this.bind(other);
    }

    @Override
    public void bind(Vector other) {
        IncompatibleVectorsException.checkVectorsCompatible(this, other);
        BinaryVector binaryOther = (BinaryVector)other;
        this.bitSet.xor(binaryOther.bitSet);
    }

    @Override
    public void release(Vector other) {
        this.bind(other);
    }

    @Override
    public synchronized void normalize() {
        if (this.votingRecord == null) {
            return;
        }
        if (this.votingRecord.size() == 1) {
            this.bitSet = this.votingRecord.get(0);
            return;
        }
        if (NORMALIZE_METHOD.equals((Object)BinaryNormalizationMethod.SPATTERCODE)) {
            this.bitSet = this.concludeVote();
        } else {
            this.bitSet.xor(this.bitSet);
            long theSuperpositionSeed = 0L;
            for (int q = 0; q < this.votingRecord.size(); ++q) {
                theSuperpositionSeed += this.votingRecord.get(q).getBits()[0];
            }
            this.random.setSeed(theSuperpositionSeed);
            int max = this.totalNumberOfVotes.get();
            int maxpossiblevotesonrecord = 0;
            for (int q = 0; q < this.votingRecord.size(); ++q) {
                maxpossiblevotesonrecord = (int)((double)maxpossiblevotesonrecord + Math.pow(2.0, q));
            }
            block2: for (int x = 1; x <= maxpossiblevotesonrecord; ++x) {
                this.setTempSetToExactMatches(x);
                if (this.tempSet.cardinality() == 0) continue;
                int y = this.tempSet.nextSetBit(0);
                double votes = this.minimum + x;
                double z = (votes - (double)(max / 2)) / (Math.sqrt(max) / 2.0);
                double proportion = this.erf(z / Math.sqrt(2.0));
                proportion = (1.0 + proportion) / 2.0;
                while (y != Integer.MAX_VALUE) {
                    if (this.random.nextDouble() <= proportion) {
                        this.bitSet.set(y);
                    }
                    if (++y == this.dimension) continue block2;
                    y = this.tempSet.nextSetBit(y);
                }
            }
        }
        this.votingRecord = new ArrayList();
        this.votingRecord.add(this.bitSet.clone());
        this.totalNumberOfVotes.set(1);
        this.tempSet = new FixedBitSet(this.dimension);
        this.minimum = 0;
    }

    public double erf(double z) {
        double sign = Math.signum(z);
        z = Math.abs(z);
        double a1 = 0.278393;
        double a2 = 0.230389;
        double a3 = 9.72E-4;
        double a4 = 0.078108;
        double sumterm = 1.0 + a1 * z + a2 * Math.pow(z, 2.0) + a3 * Math.pow(z, 3.0) + a4 * Math.pow(z, 4.0);
        return sign * (1.0 - 1.0 / Math.pow(sumterm, 4.0));
    }

    public synchronized void normalizeBSC() {
        if (!this.isSparse) {
            this.bitSet = this.concludeVote();
        }
        this.votingRecord = new ArrayList();
        this.votingRecord.add(this.bitSet.clone());
        this.totalNumberOfVotes.set(1);
        this.tempSet = new FixedBitSet(this.dimension);
        this.minimum = 0;
    }

    public synchronized void tallyVotes() {
        if (this.isSparse) {
            this.elementalToSemantic();
        }
        if (this.unTallied.get()) {
            try {
                this.bitSet = this.concludeVote();
                this.unTallied.set(false);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void writeToLuceneStream(IndexOutput outputStream) {
        if (this.isSparse) {
            this.elementalToSemantic();
        }
        long[] bitArray = this.bitSet.getBits();
        for (int i = 0; i < bitArray.length; ++i) {
            try {
                outputStream.writeLong(bitArray[i]);
                continue;
            }
            catch (ClosedByInterruptException e) {
                throw new QueryInterruptedException("Transaction was aborted by the user");
            }
            catch (IOException e) {
                logger.severe("Couldn't write binary vector to lucene output stream.");
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void writeToLuceneStream(IndexOutput outputStream, int k) {
        if (this.isSparse) {
            this.elementalToSemantic();
        }
        long[] bitArray = this.bitSet.getBits();
        for (int i = 0; i < k / 64; ++i) {
            try {
                outputStream.writeLong(bitArray[i]);
                continue;
            }
            catch (ClosedByInterruptException e) {
                throw new QueryInterruptedException("Transaction was aborted by the user");
            }
            catch (IOException e) {
                logger.severe("Couldn't write binary vector to lucene output stream.");
                logger.severe(e.toString());
            }
        }
    }

    @Override
    public void readFromLuceneStream(IndexInput inputStream) {
        long[] bitArray = new long[this.dimension / 64];
        for (int i = 0; i < this.dimension / 64; ++i) {
            try {
                bitArray[i] = inputStream.readLong();
                continue;
            }
            catch (IOException e) {
                logger.severe("Couldn't read binary vector from lucene output stream.");
                logger.severe(e.toString());
            }
        }
        this.bitSet = new FixedBitSet(bitArray, this.dimension);
        this.isSparse = true;
    }

    @Override
    public void readFromByteBuffer(ByteBuffer byteBuffer) {
        long[] bitArray = new long[this.dimension / 64];
        for (int i = 0; i < this.dimension / 64; ++i) {
            bitArray[i] = byteBuffer.getLong();
            logger.severe("Couldn't read binary vector from lucene output stream.");
        }
        this.bitSet = new FixedBitSet(bitArray, this.dimension);
        this.isSparse = true;
    }

    @Override
    public String writeToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.dimension; ++i) {
            builder.append(this.bitSet.get(i) ? "1" : "0");
        }
        return builder.toString();
    }

    public String writeLongToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.bitSet.getBits().length; ++i) {
            builder.append(Long.toString(this.bitSet.getBits()[i]) + "|");
        }
        return builder.toString();
    }

    @Override
    public void readFromString(String input) {
        if (input.length() != this.dimension) {
            throw new IllegalArgumentException("Found " + input.length() + " possible coordinates: expected " + this.dimension);
        }
        for (int i = 0; i < this.dimension; ++i) {
            if (input.charAt(i) != '1') continue;
            this.bitSet.set(i);
        }
    }

    protected void elementalToSemantic() {
        if (!this.isSparse) {
            logger.warning("Tried to transform an elemental vector which is not in fact elemental.This may be a programming error.");
            return;
        }
        this.votingRecord = new ArrayList();
        this.tempSet = new FixedBitSet(this.dimension);
        if (this.bitSet.cardinality() != 0) {
            this.superposeBitSet(this.bitSet.clone(), 1.0);
        }
        this.isSparse = false;
    }

    public void permute(int[] permutation) {
        if (permutation.length != this.getDimension() / 64) {
            throw new IllegalArgumentException("Binary vector of dimension " + this.getDimension() + " must have permutation of length " + this.getDimension() / 64 + " not " + permutation.length);
        }
        long[] coordinates = this.bitSet.getBits();
        long[] newCoordinates = new long[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            int positionToAdd = i;
            positionToAdd = permutation[positionToAdd];
            newCoordinates[i] = coordinates[positionToAdd];
        }
        this.bitSet = new FixedBitSet(newCoordinates, this.getDimension());
    }

    protected BinaryVector(FixedBitSet inSet) {
        this.dimension = inSet.length();
        this.bitSet = inSet;
    }

    protected int bitLength() {
        return this.bitSet.getBits().length;
    }

    protected int numRows() {
        if (this.isSparse) {
            return 0;
        }
        return this.votingRecord.size();
    }

    protected FixedBitSet getCoordinates() {
        return this.bitSet;
    }

    protected void setCoordinates(FixedBitSet incomingBitSet) {
        this.bitSet = incomingBitSet;
    }

    public static void setDebugPrintLength(int length) {
        DEBUG_PRINT_LENGTH = length;
    }

    public static enum BinaryNormalizationMethod {
        SPATTERCODE,
        PROBABILISTIC;

    }
}

