/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class VerbatimLogger {
    private static VerbatimLogger singletonLogger = null;
    private static VerbatimFormatter singletonFormatter = null;
    private static Logger underlyingLogger = null;

    private VerbatimLogger() {
    }

    private static Logger getUnderlyingLogger() {
        return underlyingLogger;
    }

    private static VerbatimLogger getVerbatimLogger() {
        if (singletonLogger == null) {
            singletonLogger = new VerbatimLogger();
            ConsoleHandler cs = new ConsoleHandler();
            singletonFormatter = singletonLogger.new VerbatimFormatter();
            cs.setFormatter(singletonFormatter);
            underlyingLogger = Logger.getLogger("VerbatimLogger");
            underlyingLogger.setUseParentHandlers(false);
            for (Handler handler : underlyingLogger.getHandlers()) {
                underlyingLogger.removeHandler(handler);
            }
            underlyingLogger.addHandler(cs);
        }
        return singletonLogger;
    }

    public static void log(Level level, String message) {
        VerbatimLogger.getVerbatimLogger();
        VerbatimLogger.getUnderlyingLogger().log(level, message);
    }

    public static void severe(String message) {
        VerbatimLogger.log(Level.SEVERE, message);
    }

    public static void warning(String message) {
        VerbatimLogger.log(Level.WARNING, message);
    }

    public static void info(String message) {
        VerbatimLogger.log(Level.INFO, message);
    }

    public static void fine(String message) {
        VerbatimLogger.log(Level.FINE, message);
    }

    public static void finer(String message) {
        VerbatimLogger.log(Level.FINER, message);
    }

    public static void finest(String message) {
        VerbatimLogger.log(Level.FINEST, message);
    }

    public static boolean isCounterOutput(int counter) {
        return counter < 10000 && counter % 1000 == 0 || counter < 100000 && counter % 10000 == 0 || counter < 1000000 && counter % 100000 == 0 || counter < 10000000 && counter % 1000000 == 0 || counter % 10000000 == 0;
    }

    private class VerbatimFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            return record.getMessage();
        }
    }
}

