/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import pitt.search.semanticvectors.utils.NoDiskSpaceException;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public class FileUtil {
    static final String SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE = "semantic-vectors.minimal-free-disk-space";
    private static long hardLimit = -1L;
    private static final long FIVE_GB = 0x140000000L;

    public static void checkDiskSpace(File location) {
        long freeSpace = Math.min(location.getUsableSpace(), location.getFreeSpace());
        if (FileUtil.resolveHardLimit() > freeSpace) {
            throw new NoDiskSpaceException("Insufficient disk space at " + location);
        }
        if (0x140000000L > freeSpace) {
            VerbatimLogger.warning("The location " + location + " is running ouf of disk space with remaining " + freeSpace + " bytes");
        }
    }

    @VisibleForTesting
    static long resolveHardLimit() {
        if (hardLimit == -1L) {
            String value = System.getProperty(SEMANTIC_VECTORS_MINIMAL_FREE_DISK_SPACE);
            long limit = 0x20000000L;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    long multiplier = 1L;
                    if (value.toLowerCase().endsWith("gb")) {
                        value = value.substring(0, value.length() - 2);
                        multiplier = 0x40000000L;
                    }
                    if (value.toLowerCase().endsWith("mb")) {
                        value = value.substring(0, value.length() - 2);
                        multiplier = 0x100000L;
                    }
                    limit = (long)(Double.parseDouble(value.replace(',', '.').trim()) * (double)multiplier);
                }
                catch (NumberFormatException nfe) {
                    VerbatimLogger.warning("Invalid configuration value 'semantic-vectors.minimal-free-disk-space'. Supported formats: 0.5GB, 500MB, 536870912");
                }
            }
            hardLimit = limit;
        }
        return hardLimit;
    }

    @VisibleForTesting
    static void resetLimit() {
        hardLimit = -1L;
    }
}

