/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

public class Bobcat {
    static final int[][] sbox = new int[][]{{53553, 2982, 39135, 46508, 12285, 29403, 53274, 57271, 47329, 45037, 27174, 32406, 47740, 36933, 61740, 32665}, {9377, 39239, 45969, 27895, 2049, 62178, 34190, 64534, 25449, 8408, 29015, 20073, 42072, 65187, 62611, 15742}};

    private Bobcat() {
    }

    public static String asString(String text) {
        int[] abc = Bobcat.computeBobcat(text);
        return String.format("%04x%04x%04x", abc[0], abc[1], abc[2]);
    }

    public static long asLong(String text) {
        int[] abc = Bobcat.computeBobcat(text);
        String s = String.format("%16s%16s%16s", Integer.toBinaryString(abc[0]), Integer.toBinaryString(abc[1]), Integer.toBinaryString(abc[2])).replaceAll(" ", "0");
        return Long.parseLong(s, 2);
    }

    private static int[] computeBobcat(String text) {
        int i;
        int iLength = text.length();
        int iResidue = iLength % 8;
        int[] x = iResidue != 0 ? new int[iLength + (8 - iResidue)] : new int[iLength];
        for (i = 0; i < iLength; ++i) {
            x[i] = text.charAt(i);
        }
        if (iResidue != 0) {
            for (i = iLength; i < iLength + (8 - iResidue); ++i) {
                x[i] = 0;
            }
        }
        int[] abc = new int[]{64206, 59745, 1053};
        int len = x.length / 8;
        for (int i2 = 0; i2 < len; ++i2) {
            int[] block = new int[]{x[0 + i2 * 8], x[1 + i2 * 8], x[2 + i2 * 8], x[3 + i2 * 8], x[4 + i2 * 8], x[5 + i2 * 8], x[6 + i2 * 8], x[7 + i2 * 8]};
            Bobcat.bobcat(abc, block);
        }
        return abc;
    }

    private static void bobcat(int[] abc, int[] x) {
        int[] old = new int[]{abc[0], abc[1], abc[2]};
        Bobcat.F(abc, 5, x);
        Bobcat.keySchedule(x);
        Bobcat.F(abc, 7, x);
        Bobcat.keySchedule(x);
        Bobcat.F(abc, 9, x);
        Bobcat.feedforward(abc, old);
    }

    private static void f(int[] abc, int zero, int one, int two, int x, int m) {
        int aa = abc[zero];
        int bb = abc[one];
        int cc = abc[two];
        cc = (cc ^ x) & 0xFFFF;
        aa = aa - (sbox[0][cc & 0xF] ^ sbox[1][cc >> 8 & 0xF]) & 0xFFFF;
        bb = bb + (sbox[1][cc >> 4 & 0xF] ^ sbox[0][cc >> 12 & 0xF]) & 0xFFFF;
        bb = bb * m & 0xFFFF;
        abc[zero] = aa;
        abc[one] = bb;
        abc[two] = cc;
    }

    private static void F(int[] abc, int m, int[] x) {
        Bobcat.f(abc, 0, 1, 2, x[0], m);
        Bobcat.f(abc, 1, 2, 0, x[1], m);
        Bobcat.f(abc, 2, 0, 1, x[2], m);
        Bobcat.f(abc, 0, 1, 2, x[3], m);
        Bobcat.f(abc, 1, 2, 0, x[4], m);
        Bobcat.f(abc, 2, 0, 1, x[5], m);
        Bobcat.f(abc, 0, 1, 2, x[6], m);
        Bobcat.f(abc, 1, 2, 0, x[7], m);
    }

    private static void keySchedule(int[] x) {
        x[0] = x[0] - (x[7] ^ 0xA5A5A5A5) & 0xFFFF;
        x[1] = (x[1] ^ x[0]) & 0xFFFF;
        x[2] = x[2] + x[1] & 0xFFFF;
        x[3] = x[3] - (x[2] ^ ~x[1] << 5) & 0xFFFF;
        x[4] = (x[4] ^ x[3]) & 0xFFFF;
        x[5] = x[5] + x[4] & 0xFFFF;
        x[6] = x[6] - (x[5] ^ ~x[4] >> 6) & 0xFFFF;
        x[7] = (x[7] ^ x[6]) & 0xFFFF;
        x[0] = x[0] + x[7] & 0xFFFF;
        x[1] = x[1] - (x[0] ^ ~x[7] << 5) & 0xFFFF;
        x[2] = (x[2] ^ x[1]) & 0xFFFF;
        x[3] = x[3] + x[2] & 0xFFFF;
        x[4] = x[4] - (x[3] ^ ~x[2] >> 6) & 0xFFFF;
        x[5] = (x[5] ^ x[4]) & 0xFFFF;
        x[6] = x[6] + x[5] & 0xFFFF;
        x[7] = x[7] - (x[6] ^ 0x235689BD) & 0xFFFF;
    }

    private static void feedforward(int[] abc, int[] old) {
        abc[0] = (abc[0] ^ old[0]) & 0xFFFF;
        abc[1] = abc[1] - old[1] & 0xFFFF;
        abc[2] = abc[2] + old[2] & 0xFFFF;
    }
}

