/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.orthography;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class NumberRepresentation {
    private String startRandomSeed = "*START*";
    private String endRandomSeed = "*END*";
    private Hashtable<String, VectorStoreRAM> numberVectorsCache = new Hashtable();
    private FlagConfig flagConfig = null;
    private Vector vL;
    private Vector vR;

    public NumberRepresentation(FlagConfig flagConfig, String startSeed, String endSeed) {
        if (flagConfig == null) {
            throw new NullPointerException("flagConfig cannot be null");
        }
        if (flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
            BinaryVector.setNormalizationMethod(BinaryVector.BinaryNormalizationMethod.PROBABILISTIC);
        }
        this.startRandomSeed = startSeed;
        this.endRandomSeed = endSeed;
        this.flagConfig = flagConfig;
        Random random = new Random(Bobcat.asLong(this.startRandomSeed));
        this.vL = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
        this.vL.normalize();
        random.setSeed(Bobcat.asLong(this.endRandomSeed));
        this.vR = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
        this.vR.normalize();
        ArrayList<Vector> toOrthogonalize = new ArrayList<Vector>();
        toOrthogonalize.add(this.vL);
        toOrthogonalize.add(this.vR);
        VectorUtils.orthogonalizeVectors(toOrthogonalize);
    }

    public NumberRepresentation(FlagConfig flagConfig) {
        this(flagConfig, "*START*", "*END*");
    }

    public VectorStoreRAM getNumberVectors(int iStart, int iEnd) {
        if (this.numberVectorsCache.containsKey(iStart + ":" + iEnd)) {
            return this.numberVectorsCache.get(iStart + ":" + iEnd);
        }
        if (iEnd < iStart) {
            throw new IllegalArgumentException(String.format("End index (%d) should be greater than start index (%d).", iEnd, iStart));
        }
        VectorStoreRAM theVSR = new VectorStoreRAM(this.flagConfig);
        for (int i = 0; i <= iEnd - iStart; ++i) {
            Vector ithNumberVector = VectorUtils.weightedSuperposition(this.vL, iEnd - iStart - i, this.vR, i);
            theVSR.putVector(iStart + i, ithNumberVector);
        }
        theVSR.putVector("alpha", this.vL);
        theVSR.putVector("omega", this.vR);
        this.numberVectorsCache.put(iStart + ":" + iEnd, theVSR);
        return theVSR;
    }
}

