/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.lsh;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import pitt.search.semanticvectors.lsh.DirectByteBufferCleaner;
import pitt.search.semanticvectors.lsh.LongIterator;

public class PersistedHashMap {
    File cacheFile;
    MappedByteBuffer mbb;

    public PersistedHashMap(File file) {
        this.cacheFile = file;
    }

    public void init() throws IOException {
        if (this.cacheFile.exists() && this.cacheFile.length() != 0L) {
            try (FileChannel fileChannel = FileChannel.open(this.cacheFile.toPath(), new OpenOption[0]);){
                this.mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.cacheFile.length());
            }
        }
    }

    public void persist(TreeMap<Short, Collection<Long>> map) throws IOException {
        Throwable throwable;
        FileChannel fileChannel;
        long size = this.calculateSize(map);
        if (!this.cacheFile.exists() || this.cacheFile.length() == 0L) {
            fileChannel = FileChannel.open(this.cacheFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            throwable = null;
            try {
                MappedByteBuffer wmbb = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                this.writeHeader(wmbb, map);
                this.writeData(wmbb, map);
                wmbb.clear();
                DirectByteBufferCleaner.closeDirectByteBuffer(wmbb);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileChannel != null) {
                    if (throwable != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fileChannel.close();
                    }
                }
            }
        } else if (size != this.cacheFile.length()) {
            throw new IOException("The file does not match the map length");
        }
        fileChannel = FileChannel.open(this.cacheFile.toPath(), new OpenOption[0]);
        throwable = null;
        try {
            this.mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (fileChannel != null) {
                if (throwable != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    fileChannel.close();
                }
            }
        }
    }

    public LongIterator get(short key) {
        this.mbb.position(0);
        long headerSizeInBytes = this.mbb.getLong();
        while ((long)this.mbb.position() < headerSizeInBytes) {
            long bucketId = this.mbb.getShort();
            if (bucketId == (long)key) {
                long start = this.mbb.getLong();
                long end = (long)this.mbb.position() == headerSizeInBytes ? (long)this.mbb.limit() : this.mbb.getLong(this.mbb.position() + 2);
                return new Range(start, end).iterator();
            }
            this.mbb.position(this.mbb.position() + 8);
        }
        return new LongIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public long next() {
                return 0L;
            }
        };
    }

    public void close() {
        this.mbb.clear();
        DirectByteBufferCleaner.closeDirectByteBuffer(this.mbb);
    }

    public List<Short> keys() {
        LinkedList<Short> keys = new LinkedList<Short>();
        this.mbb.position(0);
        long headerSize = this.mbb.getLong();
        while ((long)this.mbb.position() < headerSize) {
            keys.add(this.mbb.getShort());
            this.mbb.position(this.mbb.position() + 8);
        }
        return keys;
    }

    private long calculateSize(TreeMap<Short, Collection<Long>> map) {
        long size = 0L;
        size += 8L;
        for (Collection<Long> value : map.values()) {
            size += 10L;
            size += (long)(value.size() * 8);
        }
        return size;
    }

    private void writeHeader(MappedByteBuffer wmbb, TreeMap<Short, Collection<Long>> storeHash) {
        long headerSizeInBytes = storeHash.size() * 10 + 8;
        wmbb.putLong(headerSizeInBytes);
        long prevBucketEnd = headerSizeInBytes;
        for (Map.Entry<Short, Collection<Long>> integerListEntry : storeHash.entrySet()) {
            wmbb.putShort(integerListEntry.getKey());
            wmbb.putLong(prevBucketEnd);
            prevBucketEnd += (long)(integerListEntry.getValue().size() * 8);
        }
    }

    private void writeData(MappedByteBuffer wmbb, TreeMap<Short, Collection<Long>> storeHash) {
        for (Collection<Long> value : storeHash.values()) {
            for (Long aLong : value) {
                wmbb.putLong(aLong);
            }
        }
    }

    private class Range {
        long start;
        long end;

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public LongIterator iterator() {
            PersistedHashMap.this.mbb.position((int)this.start);
            return new LongIterator(){

                @Override
                public boolean hasNext() {
                    return (long)PersistedHashMap.this.mbb.position() < Range.this.end;
                }

                @Override
                public long next() {
                    return PersistedHashMap.this.mbb.getLong();
                }
            };
        }
    }
}

