/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.experiments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorSearcher;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorUtils;
import pitt.search.semanticvectors.vectors.ZeroVectorException;

public class PSITypeLister {
    FlagConfig flagConfig;
    private VectorStore elementalVectors;
    private VectorStore semanticVectors;
    private VectorStore predicateVectors;
    private static HashMap<String, List<String>> typesToAttributes = new HashMap();

    public PSITypeLister(String[] args) throws IOException {
        this.flagConfig = FlagConfig.getFlagConfig(args);
        this.elementalVectors = VectorStoreRAM.readFromFile(this.flagConfig, this.flagConfig.elementalvectorfile());
        this.semanticVectors = VectorStoreRAM.readFromFile(this.flagConfig, this.flagConfig.semanticvectorfile());
        this.predicateVectors = VectorStoreRAM.readFromFile(this.flagConfig, this.flagConfig.boundvectorfile());
    }

    public int printBestRelations(String item) {
        Vector semanticVector = this.semanticVectors.getVector(item);
        ArrayList<String> attributes = new ArrayList<String>();
        for (ObjectVector predicateVector : Collections.list(this.predicateVectors.getAllVectors())) {
            Vector probeVector = semanticVector.copy();
            probeVector.release(predicateVector.getVector());
            for (ObjectVector elementalVector : Collections.list(this.elementalVectors.getAllVectors())) {
                double relationScore = probeVector.measureOverlap(elementalVector.getVector());
                if (!(relationScore > this.flagConfig.searchresultsminscore())) continue;
                attributes.add((String)predicateVector.getObject());
            }
        }
        String type = this.getProposedType(attributes);
        if (attributes.size() != 0 && type.equals("COUNTRY")) {
            System.out.println(String.format("'%s' is therefore a '%s'", item, type));
        }
        return type.equals("COUNTRY") ? 1 : 0;
    }

    private String getProposedType(List<String> matchedAttributes) {
        String result = null;
        for (Map.Entry<String, List<String>> entry : typesToAttributes.entrySet()) {
            for (String attribute : matchedAttributes) {
                if (!entry.getValue().contains(attribute) || result != null && result != entry.getKey()) continue;
                result = entry.getKey();
            }
        }
        return result;
    }

    public static void notUsDollar(PSITypeLister typeLister, FlagConfig flagConfig) throws ZeroVectorException {
        Vector dollar = typeLister.semanticVectors.getVector("united_states_dollar");
        Vector usesCurrency = typeLister.predicateVectors.getVector("HAS_CURRENCY-INV");
        Vector countryUsesDollar = dollar.copy();
        countryUsesDollar.release(usesCurrency);
        System.out.println("Results without negation ...");
        VectorSearcher.VectorSearcherCosine searcher = new VectorSearcher.VectorSearcherCosine(typeLister.elementalVectors, typeLister.elementalVectors, null, typeLister.flagConfig, countryUsesDollar);
        for (SearchResult result : ((VectorSearcher)searcher).getNearestNeighbors(flagConfig.numsearchresults())) {
            System.out.println(result.toTexTableString(20));
        }
        ArrayList<Vector> setToNegate = new ArrayList<Vector>();
        Vector usa = typeLister.elementalVectors.getVector("united_states");
        setToNegate.add(usa);
        setToNegate.add(countryUsesDollar);
        VectorUtils.orthogonalizeVectors(setToNegate);
        countryUsesDollar.normalize();
        System.out.println("Results with negation ...");
        searcher = new VectorSearcher.VectorSearcherCosine(typeLister.elementalVectors, typeLister.elementalVectors, null, typeLister.flagConfig, countryUsesDollar);
        for (SearchResult result : ((VectorSearcher)searcher).getNearestNeighbors(flagConfig.numsearchresults())) {
            System.out.println(result.toTexTableString(20));
        }
    }

    public static void main(String[] args) throws IOException, ZeroVectorException {
        PSITypeLister typeLister = new PSITypeLister(args);
        int numCountries = 0;
        for (ObjectVector vector : Collections.list(typeLister.semanticVectors.getAllVectors())) {
            numCountries += typeLister.printBestRelations(vector.getObject().toString());
        }
        System.out.println("Number of countries: " + numCountries);
    }

    static {
        typesToAttributes.put("COUNTRY", Arrays.asList("CAPITAL_OF-INV", "HAS_NATIONAL_ANIMAL", "HAS_CURRENCY"));
        typesToAttributes.put("CITY", Arrays.asList("CAPITAL_OF"));
        typesToAttributes.put("CURRENCY", Arrays.asList("HAS_CURRENCY-INV"));
        typesToAttributes.put("ANIMAL", Arrays.asList("HAS_NATIONAL_ANIMAL-INV"));
    }
}

