/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.collections;

import com.ontotext.trree.io.ReadWriteFile;
import gnu.trove.iterator.TObjectLongIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.collections.ModifiableVectorStore;
import pitt.search.semanticvectors.collections.VectorBufferConverter;
import pitt.search.semanticvectors.vectors.Vector;

public class FileVectorStore
implements ModifiableVectorStore {
    private int bufferSizeInBytes;
    private ReadWriteFile file;
    private VectorBufferConverter converter;
    private TObjectLongHashMap<String> keyToPos;
    private TLongObjectHashMap<String> posToKey;
    private long size;
    private boolean temp;

    public FileVectorStore(File storageFile, VectorBufferConverter converter) {
        this(storageFile, converter, true);
    }

    public FileVectorStore(File storageFile, VectorBufferConverter converter, boolean temp) {
        this.bufferSizeInBytes = converter.getBufferSizeInBytes();
        this.file = new ReadWriteFile(this.bufferSizeInBytes, storageFile, false);
        this.converter = converter;
        this.temp = temp;
        int MAPS_INITIAL_CAPACITY = (int)(0.75 * (double)this.bufferSizeInBytes / 4.0);
        this.keyToPos = new TObjectLongHashMap(MAPS_INITIAL_CAPACITY);
        this.posToKey = new TLongObjectHashMap(MAPS_INITIAL_CAPACITY);
        this.size = 0L;
        if (!temp && storageFile.exists() && storageFile.length() != 0L) {
            this.restoreMaps();
            this.size = this.keyToPos.size();
        }
    }

    @Override
    public void putVector(Object key, Vector vector) {
        long currentPosition;
        if (this.keyToPos.containsKey(key)) {
            currentPosition = this.keyToPos.get(key);
        } else {
            currentPosition = this.size;
            this.keyToPos.put((String)key, this.size++);
        }
        this.posToKey.put(currentPosition, (String)key);
        ByteBuffer byteBuffer = this.converter.writeToBuffer(vector);
        this.file.write(byteBuffer, currentPosition * (long)this.bufferSizeInBytes);
    }

    @Override
    public Vector getVector(Object object) {
        Long position = this.keyToPos.get(object);
        if (position != null) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSizeInBytes);
            this.file.read(byteBuffer, position * (long)this.bufferSizeInBytes);
            return this.converter.readFromBuffer(byteBuffer);
        }
        return null;
    }

    @Override
    public boolean containsVector(Object object) {
        return this.keyToPos.containsKey(object);
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return new Enumeration<ObjectVector>(){
            long currPos = 0L;

            @Override
            public boolean hasMoreElements() {
                return this.currPos < FileVectorStore.this.size;
            }

            @Override
            public ObjectVector nextElement() {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(FileVectorStore.this.bufferSizeInBytes);
                FileVectorStore.this.file.read(byteBuffer, this.currPos * (long)FileVectorStore.this.bufferSizeInBytes);
                return new ObjectVector(FileVectorStore.this.posToKey.get(this.currPos++), FileVectorStore.this.converter.readFromBuffer(byteBuffer));
            }
        };
    }

    @Override
    public int getNumVectors() {
        return (int)this.size;
    }

    @Override
    public void updateVector(Object key, Vector vector) {
        this.putVector(key, vector);
    }

    @Override
    public void flush() {
        this.file.flush();
        if (!this.temp) {
            this.persistKeyMap();
        }
    }

    @Override
    public void close() {
        if (this.temp) {
            this.file.delete();
        } else {
            this.persistKeyMap();
        }
    }

    private void persistKeyMap() {
        String storageFileName = this.file.getFileIdentifier().getAbsolutePath();
        File keyMap = new File(storageFileName + ".keymap");
        if (keyMap.exists()) {
            keyMap.delete();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(keyMap);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(this.keyToPos);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save keymap to file", e);
        }
    }

    private void restoreMaps() {
        String storageFileName = this.file.getFileIdentifier().getAbsolutePath();
        File keyMap = new File(storageFileName + ".keymap");
        if (!keyMap.exists()) {
            throw new RuntimeException("KeyMap file does not exist! " + keyMap.getAbsolutePath());
        }
        try (FileInputStream fileInputStream = new FileInputStream(keyMap);
             ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);){
            this.keyToPos = (TObjectLongHashMap)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Could not save keymap to file", e);
        }
        TObjectLongIterator<String> iterator = this.keyToPos.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            this.posToKey.put(iterator.value(), iterator.key());
        }
    }
}

