/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public class VectorStoreWriter {
    public static String generateHeaderString(FlagConfig flagConfig) {
        return "-vectortype " + flagConfig.vectortype().toString() + " -dimension " + Integer.toString(flagConfig.dimension());
    }

    public static void writeVectors(String storeName, FlagConfig flagConfig, VectorStore objectVectors) throws IOException {
        String vectorFileName = VectorStoreUtils.getStoreFileName(storeName, flagConfig);
        switch (flagConfig.indexfileformat()) {
            case LUCENE: {
                VectorStoreWriter.writeVectorsInLuceneFormat(vectorFileName, flagConfig, objectVectors);
                break;
            }
            case TEXT: {
                VectorStoreWriter.writeVectorsInTextFormat(vectorFileName, flagConfig, objectVectors);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown -indexfileformat: " + (Object)((Object)flagConfig.indexfileformat()));
            }
        }
    }

    public static void writeVectorsInLuceneFormat(String vectorFileName, FlagConfig flagConfig, VectorStore objectVectors) throws IOException {
        VerbatimLogger.info("About to write " + objectVectors.getNumVectors() + " vectors of dimension " + flagConfig.dimension() + " to Lucene format file: " + vectorFileName + " ... ");
        File vectorFile = new File(vectorFileName);
        Files.deleteIfExists(vectorFile.toPath());
        String parentPath = vectorFile.getParent();
        if (parentPath == null) {
            parentPath = "";
        }
        FSDirectory fsDirectory = FSDirectory.open(FileSystems.getDefault().getPath(parentPath, new String[0]));
        IndexOutput outputStream = fsDirectory.createOutput(vectorFile.getName(), IOContext.DEFAULT);
        TreeMap<String, Long> entityMap = new TreeMap<String, Long>();
        VectorStoreWriter.writeToIndexOutput(objectVectors, flagConfig, outputStream, entityMap);
        File mapFile = new File(vectorFile.getAbsolutePath() + ".map");
        Files.deleteIfExists(mapFile.toPath());
        VectorStoreWriter.writeEntityMap(entityMap, mapFile);
        outputStream.close();
        fsDirectory.close();
    }

    private static void writeEntityMap(TreeMap<String, Long> entityMap, File file) throws IOException {
        try (DataOutputStream os = new DataOutputStream(new FileOutputStream(file));){
            for (Long value : entityMap.values()) {
                os.writeLong(value);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToIndexOutput(VectorStore objectVectors, FlagConfig flagConfig, IndexOutput outputStream, Map<String, Long> entityMap) throws IOException {
        outputStream.writeString(VectorStoreWriter.generateHeaderString(flagConfig));
        Enumeration<ObjectVector> vecEnum = objectVectors.getAllVectors();
        while (vecEnum.hasMoreElements()) {
            ObjectVector objectVector = vecEnum.nextElement();
            if (entityMap != null) {
                entityMap.put(objectVector.getObject().toString(), outputStream.getFilePointer());
            }
            outputStream.writeString(objectVector.getObject().toString());
            objectVector.getVector().writeToLuceneStream(outputStream);
        }
        VerbatimLogger.info("finished writing vectors.\n");
    }

    public static void writeVectorsInTextFormat(String vectorFileName, FlagConfig flagConfig, VectorStore objectVectors) throws IOException {
        VerbatimLogger.info("About to write " + objectVectors.getNumVectors() + " vectors of dimension " + flagConfig.dimension() + " to text file: " + vectorFileName + " ... ");
        BufferedWriter outBuf = new BufferedWriter(new FileWriter(vectorFileName));
        VectorStoreWriter.writeToTextBuffer(objectVectors, flagConfig, outBuf);
        outBuf.close();
        VerbatimLogger.info("finished writing vectors.\n");
    }

    public static void writeToTextBuffer(VectorStore objectVectors, FlagConfig flagConfig, BufferedWriter outBuf) throws IOException {
        Enumeration<ObjectVector> vecEnum = objectVectors.getAllVectors();
        outBuf.write(VectorStoreWriter.generateHeaderString(flagConfig) + "\n");
        while (vecEnum.hasMoreElements()) {
            ObjectVector objectVector = vecEnum.nextElement();
            outBuf.write(objectVector.getObject().toString().replaceAll("\\|", ";") + "|");
            outBuf.write(objectVector.getVector().writeToString());
            outBuf.write("\n");
        }
    }
}

