/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStoreReaderLucene;
import pitt.search.semanticvectors.VectorStoreReaderText;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.RealVector;

public class VectorStoreTranslater {
    public static String usageMessage = "VectorStoreTranslater class in pitt.search.semanticvectors\nUsage: java pitt.search.semanticvector.VectorStoreTranslater -option INFILE OUTFILE\n -option can be: -lucenetotext or -texttolucene";

    public static void main(String[] args) throws IOException {
        long ONE_GB = (long)Math.pow(1024.0, 3.0);
        if (args.length < 3) {
            VerbatimLogger.info("You gave " + args.length + " arguments aside from the command line flags, there must be at least 3.\n");
            System.err.println(usageMessage);
            throw new IllegalArgumentException();
        }
        Options option = null;
        if (args[0].equalsIgnoreCase("-lucenetotext")) {
            option = Options.LUCENE_TO_TEXT;
        } else if (args[0].equalsIgnoreCase("-texttolucene")) {
            option = Options.TEXT_TO_LUCENE;
        } else if (args[0].equalsIgnoreCase("-lucenetoword2vec")) {
            option = Options.LUCENE_TO_WORD2VEC;
        } else {
            System.err.println(usageMessage);
            throw new IllegalArgumentException();
        }
        String infile = args[1];
        String outfile = args[2];
        FlagConfig flagConfig = FlagConfig.getFlagConfig(null);
        if (option == Options.LUCENE_TO_TEXT) {
            VectorStoreReaderLucene vecReader = new VectorStoreReaderLucene(infile, flagConfig);
            VerbatimLogger.info("Writing term vectors to " + outfile + "\n");
            VectorStoreWriter.writeVectorsInTextFormat(outfile, flagConfig, vecReader);
            vecReader.close();
        } else if (option == Options.LUCENE_TO_WORD2VEC) {
            VectorStoreReaderLucene vecReader = new VectorStoreReaderLucene(infile, flagConfig);
            VerbatimLogger.info("Writing term vectors to " + outfile + "\n");
            FileOutputStream theOutput = new FileOutputStream(new File(outfile));
            Charset cs = Charset.forName("UTF-8");
            String header = String.format("%d %d\n", vecReader.getNumVectors(), flagConfig.dimension());
            ByteBuffer buffer = ByteBuffer.allocate(4 * flagConfig.dimension());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            ((OutputStream)theOutput).write(header.getBytes(cs));
            Enumeration<ObjectVector> allVecs = vecReader.getAllVectors();
            while (allVecs.hasMoreElements()) {
                ObjectVector nextObjectVector = allVecs.nextElement();
                String nextTerm = nextObjectVector.getObject().toString();
                float[] nextVec = ((RealVector)nextObjectVector.getVector()).getCoordinates();
                ((OutputStream)theOutput).write(String.format("%s ", nextTerm).getBytes(cs));
                buffer.clear();
                for (int j = 0; j < flagConfig.dimension(); ++j) {
                    buffer.putFloat(nextVec[j]);
                }
                ((OutputStream)theOutput).write(buffer.array());
                ((OutputStream)theOutput).write(10);
            }
            theOutput.flush();
            ((OutputStream)theOutput).close();
        } else if (option == Options.TEXT_TO_LUCENE) {
            VectorStoreReaderText vecReader = new VectorStoreReaderText(infile, flagConfig);
            VerbatimLogger.info("Writing term vectors to " + outfile + "\n");
            VectorStoreWriter.writeVectorsInLuceneFormat(outfile, flagConfig, vecReader);
            vecReader.close();
        }
    }

    private static enum Options {
        LUCENE_TO_TEXT,
        TEXT_TO_LUCENE,
        LUCENE_TO_WORD2VEC;

    }
}

