/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.util.Enumeration;
import java.util.Hashtable;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreDeterministic;
import pitt.search.semanticvectors.orthography.NumberRepresentation;
import pitt.search.semanticvectors.orthography.StringEdit;
import pitt.search.semanticvectors.vectors.Vector;

public class VectorStoreOrthographical
implements VectorStore,
CloseableVectorStore {
    private FlagConfig flagConfig;
    private Hashtable<Object, ObjectVector> objectVectors;
    private boolean cacheVectors = true;
    private NumberRepresentation theNumbers;
    private StringEdit stringVectors;
    private VectorStore letterVectors;

    public VectorStoreOrthographical(FlagConfig flagConfig) {
        this(flagConfig, new VectorStoreDeterministic(flagConfig));
    }

    public VectorStoreOrthographical(FlagConfig flagConfig, VectorStore letterVectors) {
        this.flagConfig = flagConfig;
        this.letterVectors = letterVectors;
        this.objectVectors = new Hashtable();
        this.theNumbers = new NumberRepresentation(flagConfig);
        this.stringVectors = new StringEdit(flagConfig, this.theNumbers, letterVectors);
    }

    @Override
    public void close() {
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return this.objectVectors.elements();
    }

    @Override
    public int getNumVectors() {
        return this.objectVectors.size();
    }

    public void clear() {
        this.objectVectors.clear();
    }

    public void enableVectorCache(boolean cacheVectors) {
        this.cacheVectors = cacheVectors;
    }

    @Override
    public Vector getVector(Object desiredObject) throws NullPointerException {
        ObjectVector objectVector = this.objectVectors.get(desiredObject);
        if (objectVector != null) {
            return objectVector.getVector();
        }
        Vector v = this.stringVectors.getStringVector(desiredObject.toString());
        if (this.cacheVectors) {
            this.objectVectors.put(desiredObject, new ObjectVector(desiredObject, v));
        }
        return v;
    }

    @Override
    public boolean containsVector(Object object) {
        return this.objectVectors.containsKey(object);
    }
}

