/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharArraySet;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorSearcher;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreDeterministic;
import pitt.search.semanticvectors.VectorStoreOrthographical;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.ZeroVectorException;

public class SearchBatch {
    private static final Logger logger = Logger.getLogger(SearchBatch.class.getCanonicalName());
    private static LuceneUtils luceneUtils;
    public static String usageMessage;

    /*
     * Could not resolve type clashes
     */
    public static void runSearch(FlagConfig flagConfig) throws IllegalArgumentException {
        if (flagConfig == null) {
            throw new NullPointerException("flagConfig cannot be null");
        }
        if (flagConfig.remainingArgs == null) {
            throw new IllegalArgumentException("No query terms left after flag parsing!");
        }
        String[] queryArgs = flagConfig.remainingArgs;
        VectorStore queryVecReader = null;
        VectorStoreRAM boundVecReader = null;
        VectorStore elementalVecReader = null;
        VectorStoreRAM semanticVecReader = null;
        VectorStoreRAM predicateVecReader = null;
        VectorStore searchVecReader = null;
        try {
            if (!(flagConfig.elementalvectorfile().equals("elementalvectors") || flagConfig.semanticvectorfile().equals("semanticvectors") || flagConfig.elementalpredicatevectorfile().equals("predicatevectors"))) {
                VerbatimLogger.info("Opening elemental query vector store from file: " + flagConfig.elementalvectorfile() + "\n");
                VerbatimLogger.info("Opening semantic query vector store from file: " + flagConfig.semanticvectorfile() + "\n");
                VerbatimLogger.info("Opening predicate query vector store from file: " + flagConfig.elementalpredicatevectorfile() + "\n");
                if (flagConfig.elementalvectorfile().equals("deterministic")) {
                    if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.ORTHOGRAPHIC)) {
                        elementalVecReader = new VectorStoreOrthographical(flagConfig);
                    } else if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH)) {
                        elementalVecReader = new VectorStoreDeterministic(flagConfig);
                    } else {
                        VerbatimLogger.info("Please select either -elementalmethod orthographic OR -elementalmethod contenthash depending upon the deterministic approach you would like used.");
                    }
                } else {
                    elementalVecReader = new VectorStoreRAM(flagConfig);
                    elementalVecReader.initFromFile(flagConfig.elementalvectorfile());
                }
                semanticVecReader = new VectorStoreRAM(flagConfig);
                semanticVecReader.initFromFile(flagConfig.semanticvectorfile());
                predicateVecReader = new VectorStoreRAM(flagConfig);
                predicateVecReader.initFromFile(flagConfig.elementalpredicatevectorfile());
            } else {
                VerbatimLogger.info("Opening query vector store from file: " + flagConfig.queryvectorfile() + "\n");
                if (flagConfig.queryvectorfile().equals("deterministic")) {
                    if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.ORTHOGRAPHIC)) {
                        queryVecReader = new VectorStoreOrthographical(flagConfig);
                    } else if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH)) {
                        queryVecReader = new VectorStoreDeterministic(flagConfig);
                    } else {
                        VerbatimLogger.info("Please select either -elementalmethod orthographic OR -elementalmethod contenthash depending upon the deterministic approach you would like used.");
                    }
                } else {
                    queryVecReader = new VectorStoreRAM(flagConfig);
                    ((VectorStoreRAM)queryVecReader).initFromFile(flagConfig.queryvectorfile());
                }
            }
            if (flagConfig.boundvectorfile().length() > 0) {
                VerbatimLogger.info("Opening second query vector store from file: " + flagConfig.boundvectorfile() + "\n");
                boundVecReader = new VectorStoreRAM(flagConfig);
                boundVecReader.initFromFile(flagConfig.boundvectorfile());
            }
            if (flagConfig.queryvectorfile().equals(flagConfig.searchvectorfile()) || flagConfig.searchvectorfile().isEmpty()) {
                searchVecReader = queryVecReader;
            } else {
                VerbatimLogger.info("Opening search vector store from file: " + flagConfig.searchvectorfile() + "\n");
                searchVecReader = new VectorStoreRAM(flagConfig);
                ((VectorStoreRAM)searchVecReader).initFromFile(flagConfig.searchvectorfile());
            }
            if (!flagConfig.luceneindexpath().isEmpty()) {
                try {
                    luceneUtils = new LuceneUtils(flagConfig);
                }
                catch (IOException e) {
                    logger.warning("Couldn't open Lucene index at " + flagConfig.luceneindexpath() + ". Will continue without term weighting.");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            BufferedReader queryReader = new BufferedReader(new FileReader(new File(queryArgs[0])));
            String queryString = queryReader.readLine();
            int qcnt = 0;
            while (queryString != null) {
                ArrayList<String> queryTerms = new ArrayList<String>();
                ++qcnt;
                if (!flagConfig.searchtype().equals((Object)Search.SearchType.ANALOGY)) {
                    StandardAnalyzer analyzer = new StandardAnalyzer(new CharArraySet(new ArrayList(), true));
                    TokenStream stream = analyzer.tokenStream(null, new StringReader(queryString));
                    CharTermAttribute cattr = stream.addAttribute(CharTermAttribute.class);
                    stream.reset();
                    while (stream.incrementToken()) {
                        String term = cattr.toString();
                        if (luceneUtils != null && luceneUtils.stoplistContains(term)) continue;
                        if (!flagConfig.matchcase()) {
                            term = term.toLowerCase();
                        }
                        queryTerms.add(term);
                    }
                    stream.end();
                    stream.close();
                    analyzer.close();
                } else {
                    queryTerms.add(queryString);
                }
                queryArgs = queryTerms.toArray(new String[0]);
                VectorSearcher vecSearcher = null;
                String[] splitArgs = null;
                boolean allTermsRepresented = true;
                VerbatimLogger.info("Searching term vectors, searchtype " + (Object)((Object)flagConfig.searchtype()) + "\n");
                try {
                    switch (flagConfig.searchtype()) {
                        case SUM: {
                            vecSearcher = new VectorSearcher.VectorSearcherCosine(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case SUBSPACE: {
                            vecSearcher = new VectorSearcher.VectorSearcherSubspaceSim(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case MAXSIM: {
                            vecSearcher = new VectorSearcher.VectorSearcherMaxSim(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case MINSIM: {
                            vecSearcher = new VectorSearcher.VectorSearcherMinSim(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case BOUNDPRODUCT: {
                            if (queryArgs.length == 2) {
                                vecSearcher = new VectorSearcher.VectorSearcherBoundProduct(queryVecReader, (VectorStore)boundVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0], queryArgs[1]);
                                break;
                            }
                            vecSearcher = new VectorSearcher.VectorSearcherBoundProduct(elementalVecReader, (VectorStore)semanticVecReader, (VectorStore)predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                            break;
                        }
                        case BOUNDPRODUCTSUBSPACE: {
                            if (queryArgs.length == 2) {
                                vecSearcher = new VectorSearcher.VectorSearcherBoundProductSubSpace(queryVecReader, (VectorStore)boundVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0], queryArgs[1]);
                                break;
                            }
                            vecSearcher = new VectorSearcher.VectorSearcherBoundProductSubSpace(elementalVecReader, (VectorStore)semanticVecReader, (VectorStore)predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                            break;
                        }
                        case BOUNDMINIMUM: {
                            if (queryArgs.length == 2) {
                                vecSearcher = new VectorSearcher.VectorSearcherBoundMinimum(queryVecReader, (VectorStore)boundVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0], queryArgs[1]);
                                break;
                            }
                            vecSearcher = new VectorSearcher.VectorSearcherBoundMinimum(elementalVecReader, (VectorStore)semanticVecReader, (VectorStore)predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                            break;
                        }
                        case PERMUTATION: {
                            vecSearcher = new VectorSearcher.VectorSearcherPerm(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case BALANCEDPERMUTATION: {
                            vecSearcher = new VectorSearcher.BalancedVectorSearcherPerm(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case ANALOGY: {
                            for (String searchTerm : splitArgs = queryArgs[0].split(" ")) {
                                if (queryVecReader.containsVector(searchTerm)) continue;
                                allTermsRepresented = false;
                            }
                            vecSearcher = new VectorSearcher.AnalogySearcher(queryVecReader, searchVecReader, luceneUtils, flagConfig, splitArgs);
                            break;
                        }
                        case LUCENE: {
                            vecSearcher = new VectorSearcher.VectorSearcherLucene(luceneUtils, flagConfig, queryArgs);
                            break;
                        }
                        case PRINTQUERY: {
                            Vector queryVector = CompoundVectorBuilder.getQueryVector(queryVecReader, luceneUtils, flagConfig, queryArgs);
                            System.out.println(queryVector.toString());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown search type: " + (Object)((Object)flagConfig.searchtype()));
                        }
                    }
                }
                catch (ZeroVectorException zve) {
                    logger.info(zve.getMessage());
                }
                LinkedList<Object> results = new LinkedList();
                try {
                    if (!allTermsRepresented) {
                        System.out.println("0: Missing term(s)");
                    } else {
                        results = ((VectorSearcher)vecSearcher).getNearestNeighbors(flagConfig.numsearchresults());
                    }
                }
                catch (Exception zve) {
                    // empty catch block
                }
                int cnt = 0;
                if (results.size() > 0) {
                    VerbatimLogger.info("Search output follows ...\n");
                    for (SearchResult result : results) {
                        boolean printResult = true;
                        if (flagConfig.searchtype() == Search.SearchType.ANALOGY) {
                            for (String searchTerm : splitArgs) {
                                if (!result.getObjectVector().getObject().toString().equals(searchTerm)) continue;
                                printResult = false;
                            }
                        }
                        if (!printResult) continue;
                        if (flagConfig.treceval() != -1) {
                            System.out.println(String.format("%s\t%s\t%s\t%s\t%f\t%s", qcnt, "Q0", result.getObjectVector().getObject().toString(), ++cnt, result.getScore(), "DEFAULT"));
                        } else {
                            System.out.println(String.format("%f:%s", result.getScore(), result.getObjectVector().getObject().toString()));
                        }
                        if (flagConfig.searchtype() != Search.SearchType.ANALOGY) continue;
                        break;
                    }
                }
                queryString = queryReader.readLine();
            }
            queryReader.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        try {
            FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
            SearchBatch.runSearch(flagConfig);
        }
        catch (IllegalArgumentException e) {
            System.err.println(usageMessage);
            throw e;
        }
    }

    static {
        usageMessage = "\nSearch class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.Search [-queryvectorfile query_vector_file]\n                                               [-searchvectorfile search_vector_file]\n                                               [-luceneindexpath path_to_lucene_index]\n                                               [-searchtype TYPE]\n                                               <QUERYTERMS>\nIf no query or search file is given, default will be\n    termvectors.bin in local directory.\n-luceneindexpath argument is needed if to get term weights from\n    term frequency, doc frequency, etc. in lucene index.\n-searchtype can be one of SUM, SUBSPACE, MAXSIM, MINSIM\n    BALANCEDPERMUTATION, PERMUTATION, PRINTQUERY\n<QUERYTERMS> should be a list of words, separated by spaces.\n    If the term NOT is used, terms after that will be negated.";
    }

    public static enum SearchType {
        SUM,
        SUBSPACE,
        MAXSIM,
        MINSIM,
        PERMUTATION,
        BALANCEDPERMUTATION,
        BOUNDPRODUCT,
        LUCENE,
        BOUNDMINIMUM,
        BOUNDPRODUCTSUBSPACE,
        ANALOGY,
        PRINTQUERY;

    }
}

