/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import pitt.search.semanticvectors.DocVectors;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.IncrementalDocVectors;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class SRI
implements VectorStore {
    private VectorStoreRAM termVectors;
    private VectorStore indexVectors;
    private FlagConfig flagConfig;
    private LuceneUtils lUtils;
    private static final Logger logger = Logger.getLogger(SRI.class.getCanonicalName());

    public SRI(FlagConfig flagConfig) throws IOException, RuntimeException {
        this.flagConfig = flagConfig;
        this.termVectors = new VectorStoreRAM(flagConfig);
        this.lUtils = new LuceneUtils(flagConfig);
        this.initializeVectorStores();
        int numdocs = this.lUtils.getNumDocs();
        for (int dc = 0; dc < numdocs; ++dc) {
            if (dc % 10000 == 0 || dc < 10000 && dc % 1000 == 0) {
                System.err.print(dc + " ... ");
            }
            for (String field : flagConfig.contentsfields()) {
                int x;
                BytesRef text;
                Terms terms = this.lUtils.getTermVector(dc, field);
                if (terms == null) {
                    VerbatimLogger.severe("No term vector for document " + dc);
                    continue;
                }
                ArrayList<String> localTerms = new ArrayList<String>();
                ArrayList<Integer> freqs = new ArrayList<Integer>();
                Hashtable<Integer, Integer> localTermPositions = new Hashtable<Integer, Integer>();
                TermsEnum termsEnum = terms.iterator();
                int termcount = 0;
                while ((text = termsEnum.next()) != null) {
                    String theTerm = text.utf8ToString();
                    if (!this.termVectors.containsVector(theTerm)) continue;
                    PostingsEnum docsAndPositions = termsEnum.postings(null);
                    if (docsAndPositions == null) {
                        return;
                    }
                    docsAndPositions.nextDoc();
                    freqs.add(docsAndPositions.freq());
                    localTerms.add(theTerm);
                    for (int x2 = 0; x2 < docsAndPositions.freq(); ++x2) {
                        localTermPositions.put(new Integer(docsAndPositions.nextPosition()), termcount);
                    }
                    ++termcount;
                }
                int numwords = freqs.size();
                float norm = 0.0f;
                float[] freaks = new float[freqs.size()];
                for (x = 0; x < freaks.length; ++x) {
                    int freq = (Integer)freqs.get(x);
                    String aTerm = (String)localTerms.get(x);
                    float globalweight = this.lUtils.getGlobalTermWeight(new Term(field, aTerm));
                    float localweight = this.lUtils.getLocalTermWeight(freq);
                    freaks[x] = localweight * globalweight;
                    norm = (float)((double)norm + Math.pow(freaks[x], 2.0));
                }
                norm = (float)Math.sqrt(norm);
                for (x = 0; x < freaks.length; ++x) {
                    freaks[x] = freaks[x] / norm;
                }
                Vector[] localindexvectors = new Vector[numwords];
                Vector[] localtermvectors = new Vector[numwords];
                for (int tcn = 0; tcn < numwords; tcn = (int)((short)(tcn + 1))) {
                    if (!this.termVectors.containsVector(localTerms.get(tcn))) continue;
                    localindexvectors[tcn] = this.indexVectors.getVector(localTerms.get(tcn));
                    localtermvectors[tcn] = this.termVectors.getVector(localTerms.get(tcn));
                }
                for (int x3 = 0; x3 < localTerms.size() - 1; ++x3) {
                    for (int y = x3 + 1; y < localTerms.size(); ++y) {
                        if (localtermvectors[x3] == null || localtermvectors[y] == null) continue;
                        float freq = freaks[x3];
                        float freq2 = freaks[y];
                        float mult = freq * freq2;
                        localtermvectors[x3].superpose(localindexvectors[y], mult, null);
                        localtermvectors[y].superpose(localindexvectors[x3], mult, null);
                    }
                }
            }
        }
        logger.info("\nCreated " + this.termVectors.getNumVectors() + " term vectors ...");
        logger.info("\nNormalizing term vectors");
        Enumeration<ObjectVector> e = this.termVectors.getAllVectors();
        while (e.hasMoreElements()) {
            ObjectVector temp = e.nextElement();
            temp.getVector().normalize();
        }
        VectorStoreWriter.writeVectorsInLuceneFormat("sritermvectors.bin", flagConfig, this.termVectors);
        if (flagConfig.docindexing() != DocVectors.DocIndexingStrategy.NONE) {
            IncrementalDocVectors.createIncrementalDocVectors(this.termVectors, flagConfig, new LuceneUtils(flagConfig));
        }
    }

    @Override
    public Vector getVector(Object term) {
        return this.termVectors.getVector(term);
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return this.termVectors.getAllVectors();
    }

    private void initializeVectorStores() throws IOException {
        this.termVectors = new VectorStoreRAM(this.flagConfig);
        if (this.flagConfig.initialtermvectors().isEmpty()) {
            this.indexVectors = new ElementalVectorStore(this.flagConfig);
        } else {
            this.indexVectors = new VectorStoreRAM(this.flagConfig);
            ((VectorStoreRAM)this.indexVectors).initFromFile(this.flagConfig.initialtermvectors());
        }
        for (String fieldName : this.flagConfig.contentsfields()) {
            BytesRef bytes;
            Terms terms = this.lUtils.getTermsForField(fieldName);
            TermsEnum termEnum = terms.iterator();
            int tc = 0;
            while ((bytes = termEnum.next()) != null) {
                Term term = new Term(fieldName, bytes);
                if (this.termVectors.getVector(term.text()) != null || !this.lUtils.termFilter(term)) continue;
                ++tc;
                Vector termVector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
                this.termVectors.putVector(term.text(), termVector);
            }
            VerbatimLogger.info(String.format("There are %d terms (and %d docs)", tc, this.lUtils.getNumDocs()));
        }
    }

    @Override
    public boolean containsVector(Object object) {
        return this.termVectors.containsVector(object);
    }

    @Override
    public int getNumVectors() {
        return this.termVectors.getNumVectors();
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        args = flagConfig.remainingArgs;
        if (flagConfig.luceneindexpath().isEmpty()) {
            throw new IllegalArgumentException("-luceneindexpath argument must be provided.");
        }
        VerbatimLogger.info("Building SRI model from index in: " + flagConfig.luceneindexpath() + "\n");
        VerbatimLogger.info("Minimum frequency = " + flagConfig.minfrequency() + "\n");
        VerbatimLogger.info("Maximum frequency = " + flagConfig.maxfrequency() + "\n");
        VerbatimLogger.info("Number non-alphabet characters = " + flagConfig.maxnonalphabetchars() + "\n");
        new SRI(flagConfig);
    }
}

