/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import pitt.search.lucene.IndexFilePositions;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.DocVectors;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.TermTermVectorsFromLucene;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.VectorType;

public class FlagConfig {
    private static final Logger logger = Logger.getLogger(FlagConfig.class.getCanonicalName());
    public String[] remainingArgs;
    private String input_index = "";
    private boolean literal_index = false;
    private int lsh_hashes_num = 0;
    private int lsh_max_bits_diff = 0;
    private int dimension = 200;
    private VectorType vectortype = VectorType.REAL;
    private RealVector.RealBindMethod realbindmethod = RealVector.RealBindMethod.CONVOLUTION;
    private ElementalVectorStore.ElementalGenerationMethod elementalmethod = ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH;
    private double samplingthreshold = -1.0;
    public boolean subsampleinwindow = false;
    public boolean balanced_subwords = false;
    public boolean exactwindowpositions = false;
    public boolean notnormalized = false;
    public int numthreads = 4;
    public int negsamples = 5;
    public int seedlength = 10;
    private int minfrequency = 0;
    private int maxfrequency = Integer.MAX_VALUE;
    private int maxnonalphabetchars = Integer.MAX_VALUE;
    private int mintermlength = 0;
    private boolean filteroutnumbers = false;
    private boolean bindnotreleasehack = false;
    private boolean hybridvectors = false;
    private int numsearchresults = 20;
    private int treceval = -1;
    private String jsonfile = "";
    private int pathfinderQ = -1;
    private double pathfinderR = Double.POSITIVE_INFINITY;
    private double searchresultsminscore = -1.0;
    private int numclusters = 10;
    private int trainingcycles = 0;
    private boolean rescaleintraining = false;
    private int windowradius = 5;
    private Search.SearchType searchtype = Search.SearchType.SUM;
    private boolean fieldweight = false;
    private LuceneUtils.TermWeight termweight = LuceneUtils.TermWeight.IDF;
    private boolean usetermweightsintermsearch = false;
    public boolean stdev = false;
    private boolean expandsearchspace = false;
    private boolean expandsearchspace3 = false;
    private VectorStoreUtils.VectorStoreFormat indexfileformat = VectorStoreUtils.VectorStoreFormat.LUCENE;
    private String termvectorsfile = "termvectors";
    private String docvectorsfile = "docvectors";
    private String termtermvectorsfile = "termtermvectors";
    private String queryvectorfile = "termvectors";
    private String searchvectorfile = "";
    private String boundvectorfile = "";
    private String elementalvectorfile = "elementalvectors";
    private String permutationcachefile = "permutationvectors";
    private String semanticvectorfile = "semanticvectors";
    private String elementalpredicatevectorfile = "predicatevectors";
    private String semanticpredicatevectorfile = "semanticpredicatevectors";
    private String permutedvectorfile = "permtermvectors";
    private String proximityvectorfile = "proxtermvectors";
    private String directionalvectorfile = "drxntermvectors";
    private String embeddingvectorfile = "embeddingvectors";
    private String permplustermvectorfile = "permplustermvectors";
    private TermTermVectorsFromLucene.PositionalMethod positionalmethod = TermTermVectorsFromLucene.PositionalMethod.BASIC;
    private TermTermVectorsFromLucene.EncodingMethod encodingmethod = TermTermVectorsFromLucene.EncodingMethod.RANDOM_INDEXING;
    private IndexFilePositions.AnalysisMethod analysismethod = IndexFilePositions.AnalysisMethod.STANDARDANALYZER;
    private boolean aggressivesubsampling = false;
    private boolean semtypesandcuis = false;
    private boolean mutablepredicatevectors = false;
    private boolean subword_embeddings = false;
    private int minimum_ngram_length = 3;
    private int maximum_ngram_length = 6;
    private boolean discountnegativesampling = false;
    private double initial_alpha = 0.05;
    private List<String> stopWordsList = new ArrayList<String>();
    private String stoplistfile = "";
    private String startlistfile = "";
    private String luceneindexpath = "";
    private String initialtermvectors = "";
    private String initialdocumentvectors = "";
    private DocVectors.DocIndexingStrategy docindexing = DocVectors.DocIndexingStrategy.INCREMENTAL;
    private CompoundVectorBuilder.VectorLookupSyntax vectorlookupsyntax = CompoundVectorBuilder.VectorLookupSyntax.EXACTMATCH;
    private boolean matchcase = false;
    private String batchcompareseparator = "\\|";
    private boolean suppressnegatedqueries = false;
    private String[] contentsfields = new String[]{"contents"};
    private String docidfield = "path";

    private FlagConfig() {
        Field[] fields = FlagConfig.class.getDeclaredFields();
        for (int q = 0; q < fields.length; ++q) {
            fields[q].setAccessible(true);
        }
    }

    public String input_index() {
        return this.input_index;
    }

    public boolean literal_index() {
        return this.literal_index;
    }

    public int lsh_hashes_num() {
        return this.lsh_hashes_num;
    }

    public int lsh_max_bits_diff() {
        return this.lsh_max_bits_diff;
    }

    public int dimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.makeFlagsCompatible();
    }

    public VectorType vectortype() {
        return this.vectortype;
    }

    public void setVectortype(VectorType vectortype) {
        this.vectortype = vectortype;
        this.makeFlagsCompatible();
    }

    public RealVector.RealBindMethod realbindmethod() {
        return this.realbindmethod;
    }

    public ElementalVectorStore.ElementalGenerationMethod elementalmethod() {
        return this.elementalmethod;
    }

    public double samplingthreshold() {
        return this.samplingthreshold;
    }

    public boolean subsampleinwindow() {
        return this.subsampleinwindow;
    }

    public boolean balanced_subwords() {
        return this.balanced_subwords;
    }

    public boolean exactwindowpositions() {
        return this.exactwindowpositions;
    }

    public boolean notnormalized() {
        return this.notnormalized;
    }

    public int numthreads() {
        return this.numthreads;
    }

    public int negsamples() {
        return this.negsamples;
    }

    public int seedlength() {
        return this.seedlength;
    }

    public int minfrequency() {
        return this.minfrequency;
    }

    public int maxfrequency() {
        return this.maxfrequency;
    }

    public int maxnonalphabetchars() {
        return this.maxnonalphabetchars;
    }

    public int mintermlength() {
        return this.mintermlength;
    }

    public boolean filteroutnumbers() {
        return this.filteroutnumbers;
    }

    public boolean bindnotreleasehack() {
        return this.bindnotreleasehack;
    }

    public boolean hybridvectors() {
        return this.hybridvectors;
    }

    public int numsearchresults() {
        return this.numsearchresults;
    }

    public int treceval() {
        return this.treceval;
    }

    public String jsonfile() {
        return this.jsonfile;
    }

    public int pathfinderQ() {
        return this.pathfinderQ;
    }

    public double pathfinderR() {
        return this.pathfinderR;
    }

    public double searchresultsminscore() {
        return this.searchresultsminscore;
    }

    public int numclusters() {
        return this.numclusters;
    }

    public int trainingcycles() {
        return this.trainingcycles;
    }

    public boolean rescaleintraining() {
        return this.rescaleintraining;
    }

    public int windowradius() {
        return this.windowradius;
    }

    public Search.SearchType searchtype() {
        return this.searchtype;
    }

    public boolean fieldweight() {
        return this.fieldweight;
    }

    public LuceneUtils.TermWeight termweight() {
        return this.termweight;
    }

    public boolean usetermweightsintermsearch() {
        return this.usetermweightsintermsearch;
    }

    public boolean stdev() {
        return this.stdev;
    }

    public boolean expandsearchspace() {
        return this.expandsearchspace;
    }

    public boolean expandsearchspace3() {
        return this.expandsearchspace3;
    }

    public VectorStoreUtils.VectorStoreFormat indexfileformat() {
        return this.indexfileformat;
    }

    public String termvectorsfile() {
        return this.termvectorsfile;
    }

    public String docvectorsfile() {
        return this.docvectorsfile;
    }

    public String termtermvectorsfile() {
        return this.termtermvectorsfile;
    }

    public String queryvectorfile() {
        return this.queryvectorfile;
    }

    public String searchvectorfile() {
        return this.searchvectorfile;
    }

    public String boundvectorfile() {
        return this.boundvectorfile;
    }

    public String elementalvectorfile() {
        return this.elementalvectorfile;
    }

    public String permutationcachefile() {
        return this.permutationcachefile;
    }

    public String semanticvectorfile() {
        return this.semanticvectorfile;
    }

    public String elementalpredicatevectorfile() {
        return this.elementalpredicatevectorfile;
    }

    public String semanticpredicatevectorfile() {
        return this.semanticpredicatevectorfile;
    }

    public String permutedvectorfile() {
        return this.permutedvectorfile;
    }

    public String proximityvectorfile() {
        return this.proximityvectorfile;
    }

    public String directionalvectorfile() {
        return this.directionalvectorfile;
    }

    public String embeddingvectorfile() {
        return this.embeddingvectorfile;
    }

    public String permplustermvectorfile() {
        return this.permplustermvectorfile;
    }

    public TermTermVectorsFromLucene.PositionalMethod positionalmethod() {
        return this.positionalmethod;
    }

    public TermTermVectorsFromLucene.EncodingMethod encodingmethod() {
        return this.encodingmethod;
    }

    public IndexFilePositions.AnalysisMethod analysismethod() {
        return this.analysismethod;
    }

    public boolean aggressivesubsampling() {
        return this.aggressivesubsampling;
    }

    public boolean semtypesandcuis() {
        return this.semtypesandcuis;
    }

    public boolean mutablepredicatevectors() {
        return this.mutablepredicatevectors;
    }

    public boolean subword_embeddings() {
        return this.subword_embeddings;
    }

    public int minimum_ngram_length() {
        return this.minimum_ngram_length;
    }

    public int maximum_ngram_length() {
        return this.maximum_ngram_length;
    }

    public boolean discountnegativesampling() {
        return this.discountnegativesampling;
    }

    public double initial_alpha() {
        return this.initial_alpha;
    }

    public String stoplistfile() {
        return this.stoplistfile;
    }

    public List<String> stopWordsList() {
        return this.stopWordsList;
    }

    public String startlistfile() {
        return this.startlistfile;
    }

    public String luceneindexpath() {
        return this.luceneindexpath;
    }

    public String initialtermvectors() {
        return this.initialtermvectors;
    }

    public String initialdocumentvectors() {
        return this.initialdocumentvectors;
    }

    public DocVectors.DocIndexingStrategy docindexing() {
        return this.docindexing;
    }

    public CompoundVectorBuilder.VectorLookupSyntax vectorlookupsyntax() {
        return this.vectorlookupsyntax;
    }

    public boolean matchcase() {
        return this.matchcase;
    }

    public String batchcompareseparator() {
        return this.batchcompareseparator;
    }

    public boolean suppressnegatedqueries() {
        return this.suppressnegatedqueries;
    }

    public String[] contentsfields() {
        return this.contentsfields;
    }

    public void setContentsfields(String[] contentsfields) {
        this.contentsfields = contentsfields;
    }

    public String docidfield() {
        return this.docidfield;
    }

    public static FlagConfig parseFlagsFromString(String header) {
        String[] args = header.split("\\s");
        return FlagConfig.getFlagConfig(args);
    }

    public static FlagConfig getFlagConfig(String[] args) throws IllegalArgumentException {
        FlagConfig flagConfig = new FlagConfig();
        if (args == null || args.length == 0) {
            flagConfig.remainingArgs = new String[0];
            return flagConfig;
        }
        int argc = 0;
        while (args[argc].charAt(0) == '-') {
            block26: {
                String flagName = args[argc];
                if (flagName.equals("-")) continue;
                while (flagName.charAt(0) == '-') {
                    flagName = flagName.substring(1, flagName.length());
                }
                try {
                    String flagValue;
                    Field field = FlagConfig.class.getDeclaredField(flagName);
                    if (field.getType().getName().equals("java.lang.String")) {
                        try {
                            flagValue = args[argc + 1];
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("option -" + flagName + " requires an argument");
                        }
                        field.set(flagConfig, flagValue);
                        argc += 2;
                        break block26;
                    }
                    if (field.getType().getName().equals("[Ljava.lang.String;")) {
                        try {
                            flagValue = args[argc + 1].toLowerCase();
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("option -" + flagName + " requires an argument");
                        }
                        field.set(flagConfig, flagValue.split(","));
                        argc += 2;
                        break block26;
                    }
                    if (field.getType().getName().equals("int")) {
                        try {
                            field.setInt(flagConfig, Integer.parseInt(args[argc + 1]));
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("option -" + flagName + " requires an argument");
                        }
                        argc += 2;
                        break block26;
                    }
                    if (field.getType().getName().equals("double")) {
                        try {
                            field.setDouble(flagConfig, Double.parseDouble(args[argc + 1]));
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("option -" + flagName + " requires an argument");
                        }
                        argc += 2;
                        break block26;
                    }
                    if (field.getType().isEnum()) {
                        try {
                            Class<?> className = field.getType();
                            try {
                                field.set(flagConfig, Enum.valueOf(className, args[argc + 1].toUpperCase()));
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException(String.format(e.getMessage() + "\nAccepted values for '-%s' are:\n%s%n", field.getName(), Arrays.asList(className.getEnumConstants()), e));
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("option -" + flagName + " requires an argument");
                        }
                        argc += 2;
                        break block26;
                    }
                    if (field.getType().getName().equals("boolean")) {
                        field.setBoolean(flagConfig, true);
                        ++argc;
                    } else {
                        logger.warning("No support for fields of type: " + field.getType().getName());
                        argc += 2;
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Command line flag not defined: " + flagName);
                }
                catch (IllegalAccessException e) {
                    logger.warning("Must be able to access all fields publicly, including: " + flagName);
                    e.printStackTrace();
                }
            }
            if (argc < args.length) continue;
            logger.fine("Consumed all command line input while parsing flags");
            flagConfig.makeFlagsCompatible();
            return flagConfig;
        }
        flagConfig.makeFlagsCompatible();
        flagConfig.remainingArgs = new String[args.length - argc];
        for (int i = 0; i < args.length - argc; ++i) {
            flagConfig.remainingArgs[i] = args[argc + i];
        }
        return flagConfig;
    }

    public static void mergeWriteableFlagsFromString(String source, FlagConfig target) {
        FlagConfig sourceConfig = FlagConfig.parseFlagsFromString(source);
        FlagConfig.mergeWriteableFlags(sourceConfig, target);
    }

    public static void mergeWriteableFlags(FlagConfig source, FlagConfig target) {
        if (target.dimension != source.dimension) {
            VerbatimLogger.info("Setting dimension of target config to: " + source.dimension + "\n");
            target.dimension = source.dimension;
        }
        if (target.vectortype != source.vectortype) {
            VerbatimLogger.info("Setting vectortype of target config to: " + (Object)((Object)source.vectortype) + "\n");
            target.vectortype = source.vectortype;
        }
        target.makeFlagsCompatible();
    }

    private void makeFlagsCompatible() {
        if (this.vectortype == VectorType.BINARY) {
            if (this.dimension % 64 != 0) {
                this.dimension = (1 + this.dimension / 64) * 64;
                logger.fine("For performance reasons, dimensions for binary vectors must be a mutliple of 64. Flags.dimension set to: " + this.dimension + ".");
            }
            if (this.seedlength != this.dimension / 2) {
                this.seedlength = this.dimension / 2;
                logger.fine("Binary vectors must be generated with a balanced number of zeros and ones. FlagConfig.seedlength set to: " + this.seedlength + ".");
            }
        }
        if (this.searchvectorfile.isEmpty()) {
            this.searchvectorfile = this.queryvectorfile;
        }
        if (this.vectortype == VectorType.REAL && this.realbindmethod == RealVector.RealBindMethod.PERMUTATION) {
            RealVector.setBindType(RealVector.RealBindMethod.PERMUTATION);
        }
        if (this.lsh_max_bits_diff > this.lsh_hashes_num) {
            throw new RuntimeException("Invalid configuration. 'lsh_max_bits_diff' must be less than 'lsh_hashes_num'!");
        }
        if (this.lsh_hashes_num > 15) {
            throw new RuntimeException("Invalid configuration. 'lsh_hashes_num' must be less than 15!");
        }
        if (this.lsh_hashes_num < 0 || this.lsh_max_bits_diff < 0) {
            throw new RuntimeException("Invalid configuration. 'lsh_max_bits_diff' and 'lsh_hashes_num' must be positive!");
        }
    }

    public void setExpandsearchspace(boolean b) {
        this.expandsearchspace = b;
    }
}

