/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class CompareTermsBatch {
    public static String usageMessage = "CompareTermsBatch class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.CompareTermsBatch \n   [-queryvectorfile vecfile] [-luceneindexpath path]\n   [-batchcompareseparator sep]\n-luceneindexpath argument may be used to get term weights from\n   term frequency, doc frequency, etc. in lucene index.\n-batchcompareseparator separator which is used to split each input line into \n   strings of terms (default '|')\nFor each line of input from STDIN, this will split the input into two strings\n   of terms at the separator, and output a similarity score to STDOUT.\nIf the term NOT is used in one of the lists, subsequent terms in \nthat list will be negated (as in Search class).";

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        String line;
        FlagConfig flagConfig;
        try {
            flagConfig = FlagConfig.getFlagConfig(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(usageMessage);
            throw e;
        }
        LuceneUtils luceneUtils = null;
        String separator = flagConfig.batchcompareseparator();
        VectorStoreRAM vecReader = null;
        VectorStoreRAM elementalVecReader = null;
        VectorStoreRAM semanticVecReader = null;
        VectorStoreRAM predicateVecReader = null;
        if (flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCT) || flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCTSUBSPACE)) {
            elementalVecReader = new VectorStoreRAM(flagConfig);
            semanticVecReader = new VectorStoreRAM(flagConfig);
            predicateVecReader = new VectorStoreRAM(flagConfig);
            elementalVecReader.initFromFile(flagConfig.elementalvectorfile());
            semanticVecReader.initFromFile(flagConfig.semanticvectorfile());
            predicateVecReader.initFromFile(flagConfig.elementalpredicatevectorfile());
        } else {
            vecReader = new VectorStoreRAM(flagConfig);
            vecReader.initFromFile(VectorStoreUtils.getStoreFileName(flagConfig.queryvectorfile(), flagConfig));
            VerbatimLogger.info(String.format("Using RAM cache of vectors from file: %s\n", flagConfig.queryvectorfile()));
        }
        if (!flagConfig.luceneindexpath().isEmpty()) {
            try {
                luceneUtils = new LuceneUtils(flagConfig);
            }
            catch (IOException e) {
                VerbatimLogger.info(String.format("Couldn't open Lucene index at %s\n", flagConfig.luceneindexpath()));
            }
        }
        if (luceneUtils == null) {
            VerbatimLogger.info("No Lucene index for query term weighting, so all terms will have same weight.\n");
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while ((line = input.readLine()) != null) {
            double simScore;
            String[] elems = line.split(separator);
            if (elems.length != 2) {
                System.err.println(usageMessage);
                throw new IllegalArgumentException("The separator '" + separator + "' must occur exactly once (found " + (elems.length - 1) + " occurrences)");
            }
            Vector vec1 = null;
            Vector vec2 = null;
            if (flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCT)) {
                vec1 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, elems[0]);
                vec2 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, elems[1]);
                simScore = vec1.measureOverlap(vec2);
                VerbatimLogger.info(String.format("Score = %7.6f. Terms: %s\n", simScore, line));
                System.out.println(simScore);
                continue;
            }
            if (flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCTSUBSPACE)) {
                ArrayList<Vector> vecs1 = CompoundVectorBuilder.getBoundProductQuerySubspaceFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, elems[0]);
                vec2 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, elems[1]);
                double simScore2 = VectorUtils.compareWithProjection(vec2, vecs1);
                VerbatimLogger.info(String.format("Score = %7.6f. Terms: %s\n", simScore2, line));
                System.out.println(simScore2);
                continue;
            }
            vec1 = CompoundVectorBuilder.getQueryVectorFromString(vecReader, luceneUtils, flagConfig, elems[0]);
            vec2 = CompoundVectorBuilder.getQueryVectorFromString(vecReader, luceneUtils, flagConfig, elems[1]);
            simScore = vec1.measureOverlap(vec2);
            VerbatimLogger.info(String.format("Score = %7.6f. Terms: %s\n", simScore, line));
            System.out.println(simScore);
        }
    }
}

