/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.lucene;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;

public class PorterAnalyzer
extends Analyzer {
    @Override
    protected Analyzer.TokenStreamComponents createComponents(String s) {
        LowerCaseTokenizer source = new LowerCaseTokenizer();
        return new Analyzer.TokenStreamComponents(source, new PorterStemFilter(source));
    }

    public String stemQuery(String query) {
        Logger logger = Logger.getLogger("pitt.search.lucene");
        String stemmedQuery = "";
        TokenStream theTS = this.createComponents(query).getTokenStream();
        try {
            while (theTS.incrementToken()) {
                String theTS_s = theTS.toString().replaceAll(".*term=", "");
                stemmedQuery = stemmedQuery + theTS_s.substring(0, theTS_s.length() - 1) + " ";
            }
        }
        catch (IOException e) {
            logger.info("Error while stemming query " + query);
        }
        return stemmedQuery;
    }

    public static void main(String[] args) throws Exception {
        PorterAnalyzer thePorterAnalyzer = new PorterAnalyzer();
        System.err.println("Attempting to perform Porter stemming on file " + args[0]);
        BufferedReader inReader = new BufferedReader(new FileReader(args[0]));
        String inLine = inReader.readLine();
        while (inLine != null) {
            System.out.println(thePorterAnalyzer.stemQuery(inLine));
            inLine = inReader.readLine();
        }
        thePorterAnalyzer.close();
        inReader.close();
    }
}

