/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.lucene;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import pitt.search.lucene.FilePositionDoc;
import pitt.search.lucene.PorterAnalyzer;
import pitt.search.semanticvectors.FlagConfig;

public class IndexFlatFilePositions {
    static Path INDEX_DIR = FileSystems.getDefault().getPath("positional_index", new String[0]);

    private IndexFlatFilePositions() {
    }

    public static void main(String[] args) {
        FlagConfig flagConfig = null;
        String usage = "java pitt.search.lucene.IndexFlatFilePositions <flat file> ";
        if (args.length == 0) {
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        if ((flagConfig = FlagConfig.getFlagConfig(args)).luceneindexpath().length() > 0) {
            INDEX_DIR = FileSystems.getDefault().getPath(flagConfig.luceneindexpath(), new String[0]);
        }
        if (Files.exists(INDEX_DIR, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot save index to '" + INDEX_DIR + "' directory, please delete it first");
        }
        try {
            Analyzer analyzer = null;
            switch (flagConfig.analysismethod()) {
                case STANDARDANALYZER: {
                    analyzer = new StandardAnalyzer(CharArraySet.EMPTY_SET);
                    break;
                }
                case PORTERSTEMMER: {
                    analyzer = new PorterAnalyzer();
                    break;
                }
                case WHITESPACEANALYZER: {
                    analyzer = new WhitespaceAnalyzer();
                }
            }
            IndexWriterConfig writerConfig = new IndexWriterConfig(analyzer);
            IndexWriter writer = new IndexWriter(FSDirectory.open(INDEX_DIR), writerConfig);
            File flatFile = new File(flagConfig.remainingArgs[0]);
            if (!flatFile.exists() || !flatFile.canRead()) {
                writer.close();
                throw new IOException("Document directory '" + flatFile.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            }
            Date start = new Date();
            System.out.println("Indexing to directory '" + INDEX_DIR + "'...");
            IndexFlatFilePositions.indexDocs(writer, flatFile);
            writer.close();
            Date end = new Date();
            System.out.println(end.getTime() - start.getTime() + " total milliseconds");
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    static void indexDocs(IndexWriter writer, File file) throws IOException {
        if (file.canRead()) {
            BufferedReader theReader = new BufferedReader(new FileReader(file));
            String inLine = theReader.readLine();
            int lineCount = 0;
            while (inLine != null) {
                if (inLine.isEmpty()) {
                    inLine = theReader.readLine();
                    continue;
                }
                try {
                    writer.addDocument(FilePositionDoc.Document(inLine, ++lineCount));
                    if (lineCount % 100000 == 0) {
                        System.out.println("added " + lineCount + " lines");
                    }
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                inLine = theReader.readLine();
            }
            theReader.close();
        }
    }
}

