/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;

@Deprecated
public class TermsQuery
extends Query
implements Accountable {
    private final Query rewritten;
    private final long ramBytesUsed;

    public TermsQuery(Collection<Term> terms) {
        HashMap<String, List> termsPerField = new HashMap<String, List>();
        for (Term term : terms) {
            List t = termsPerField.computeIfAbsent(term.field(), s -> new ArrayList());
            t.add(term.bytes());
        }
        if (termsPerField.size() == 1) {
            Map.Entry entry = termsPerField.entrySet().iterator().next();
            TermInSetQuery tisq = new TermInSetQuery((String)entry.getKey(), (Collection)entry.getValue());
            this.rewritten = tisq;
            this.ramBytesUsed = tisq.ramBytesUsed();
        } else {
            BooleanQuery.Builder bq = new BooleanQuery.Builder().setDisableCoord(true);
            long ramBytesUsed = 0L;
            for (Map.Entry entry : termsPerField.entrySet()) {
                TermInSetQuery tisq = new TermInSetQuery((String)entry.getKey(), (Collection)entry.getValue());
                bq.add(tisq, BooleanClause.Occur.SHOULD);
                ramBytesUsed += tisq.ramBytesUsed();
            }
            this.rewritten = new ConstantScoreQuery(bq.build());
            this.ramBytesUsed = ramBytesUsed;
        }
    }

    public TermsQuery(String field, Collection<BytesRef> terms) {
        TermInSetQuery tisq = new TermInSetQuery(field, terms);
        this.rewritten = tisq;
        this.ramBytesUsed = tisq.ramBytesUsed();
    }

    public TermsQuery(String field, BytesRef ... terms) {
        this(field, Arrays.asList(terms));
    }

    public TermsQuery(Term ... terms) {
        this(Arrays.asList(terms));
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return this.rewritten;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        return Objects.equals(this.rewritten, ((TermsQuery)obj).rewritten);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.rewritten.hashCode();
    }

    @Override
    public String toString(String field) {
        return this.rewritten.toString(field);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

