/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.buffer.tfloat.FloatBuffer;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tfloat.AbstractFloatIntMap;
import cern.colt.map.tfloat.OpenFloatIntHashMap;
import cern.jet.random.tfloat.AbstractFloatDistribution;
import cern.jet.random.tfloat.FloatUniform;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.FloatBinBinFunction1D;
import hep.aida.tfloat.bin.QuantileFloatBin1D;

public class DynamicFloatBin1D
extends QuantileFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected FloatArrayList elements = null;
    protected FloatArrayList sortedElements = null;
    protected boolean fixedOrder = false;
    protected boolean isSorted = true;
    protected boolean isIncrementalStatValid = true;
    protected boolean isSumOfInversionsValid = true;
    protected boolean isSumOfLogarithmsValid = true;

    public DynamicFloatBin1D() {
        this.clear();
        this.elements = new FloatArrayList();
        this.sortedElements = new FloatArrayList(0);
        this.fixedOrder = false;
        this.hasSumOfLogarithms = true;
        this.hasSumOfInversions = true;
    }

    public synchronized void add(float element) {
        this.elements.add(element);
        this.invalidateAll();
    }

    public synchronized void addAllOfFromTo(FloatArrayList list, int from, int to) {
        this.elements.addAllOfFromTo(list, from, to);
        this.invalidateAll();
    }

    public synchronized float aggregate(FloatFloatFunction aggr, FloatFunction f) {
        int s = this.size();
        if (s == 0) {
            return Float.NaN;
        }
        float a = f.apply(this.elements.getQuick(s - 1));
        int i = s - 1;
        while (--i >= 0) {
            a = aggr.apply(a, f.apply(this.elements.getQuick(i)));
        }
        return a;
    }

    public synchronized void clear() {
        super.clear();
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.sortedElements != null) {
            this.sortedElements.clear();
        }
        this.validateAll();
    }

    protected void clearAllMeasures() {
        super.clearAllMeasures();
    }

    public synchronized Object clone() {
        DynamicFloatBin1D clone = (DynamicFloatBin1D)super.clone();
        if (this.elements != null) {
            clone.elements = clone.elements.copy();
        }
        if (this.sortedElements != null) {
            clone.sortedElements = clone.sortedElements.copy();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float correlation(DynamicFloatBin1D other) {
        DynamicFloatBin1D dynamicFloatBin1D = other;
        synchronized (dynamicFloatBin1D) {
            return this.covariance(other) / (this.standardDeviation() * other.standardDeviation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float covariance(DynamicFloatBin1D other) {
        DynamicFloatBin1D dynamicFloatBin1D = other;
        synchronized (dynamicFloatBin1D) {
            if (this.size() != other.size()) {
                throw new IllegalArgumentException("both bins must have same size");
            }
            float s = 0.0f;
            int i = this.size();
            while (--i >= 0) {
                s += this.elements.getQuick(i) * other.elements.getQuick(i);
            }
            float cov = (s - this.sum() * other.sum() / (float)this.size()) / (float)this.size();
            return cov;
        }
    }

    public synchronized FloatArrayList elements() {
        return this.elements_unsafe().copy();
    }

    protected synchronized FloatArrayList elements_unsafe() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object object) {
        if (!(object instanceof DynamicFloatBin1D)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DynamicFloatBin1D other = (DynamicFloatBin1D)object;
        float[] s1 = this.sortedElements_unsafe().elements();
        DynamicFloatBin1D dynamicFloatBin1D = other;
        synchronized (dynamicFloatBin1D) {
            float[] s2 = other.sortedElements_unsafe().elements();
            int n = this.size();
            return DynamicFloatBin1D.includes(s1, s2, 0, n, 0, n) && DynamicFloatBin1D.includes(s2, s1, 0, n, 0, n);
        }
    }

    private static boolean includes(float[] array1, float[] array2, int first1, int last1, int first2, int last2) {
        while (first1 < last1 && first2 < last2) {
            if (array2[first2] < array1[first1]) {
                return false;
            }
            if (array1[first1] < array2[first2]) {
                ++first1;
                continue;
            }
            ++first1;
            ++first2;
        }
        return first2 == last2;
    }

    public synchronized void frequencies(FloatArrayList distinctElements, IntArrayList frequencies) {
        FloatDescriptive.frequencies(this.sortedElements_unsafe(), distinctElements, frequencies);
    }

    private synchronized AbstractFloatIntMap frequencyMap() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        int i = this.size();
        while (--i >= 0) {
            float element = this.elements.getQuick(i);
            ((AbstractFloatIntMap)map).put(element, 1 + ((AbstractFloatIntMap)map).get(element));
        }
        return map;
    }

    public int getMaxOrderForSumOfPowers() {
        return Integer.MAX_VALUE;
    }

    public int getMinOrderForSumOfPowers() {
        return Integer.MIN_VALUE;
    }

    protected void invalidateAll() {
        this.isSorted = false;
        this.isIncrementalStatValid = false;
        this.isSumOfInversionsValid = false;
        this.isSumOfLogarithmsValid = false;
    }

    public synchronized boolean isRebinnable() {
        return true;
    }

    public synchronized float max() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.max;
    }

    public synchronized float min() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.min;
    }

    public synchronized float moment(int k, float c) {
        return FloatDescriptive.moment(this.elements, k, c);
    }

    public synchronized float quantile(float phi) {
        return FloatDescriptive.quantile(this.sortedElements_unsafe(), phi);
    }

    public synchronized float quantileInverse(float element) {
        return FloatDescriptive.quantileInverse(this.sortedElements_unsafe(), element);
    }

    public FloatArrayList quantiles(FloatArrayList percentages) {
        return FloatDescriptive.quantiles(this.sortedElements_unsafe(), percentages);
    }

    public synchronized boolean removeAllOf(FloatArrayList list) {
        boolean changed = this.elements.removeAll(list);
        if (changed) {
            this.clearAllMeasures();
            this.invalidateAll();
            this.size = 0;
            if (this.fixedOrder) {
                this.sortedElements.removeAll(list);
                this.isSorted = true;
            }
        }
        return changed;
    }

    public synchronized void sample(int n, boolean withReplacement, FloatRandomEngine randomGenerator, FloatBuffer buffer) {
        if (randomGenerator == null) {
            randomGenerator = AbstractFloatDistribution.makeDefaultGenerator();
        }
        buffer.clear();
        if (!withReplacement) {
            if (n > this.size()) {
                throw new IllegalArgumentException("n must be less than or equal to size()");
            }
            FloatRandomSamplingAssistant sampler = new FloatRandomSamplingAssistant(n, this.size(), randomGenerator);
            int i = n;
            while (--i >= 0) {
                if (!sampler.sampleNextElement()) continue;
                buffer.add(this.elements.getQuick(i));
            }
        } else {
            FloatUniform uniform = new FloatUniform(randomGenerator);
            int s = this.size();
            int i = n;
            while (--i >= 0) {
                buffer.add(this.elements.getQuick(uniform.nextIntFromTo(0, s - 1)));
            }
            buffer.flush();
        }
    }

    public synchronized DynamicFloatBin1D sampleBootstrap(DynamicFloatBin1D other, int resamples, FloatRandomEngine randomGenerator, FloatBinBinFunction1D function) {
        if (randomGenerator == null) {
            randomGenerator = AbstractFloatDistribution.makeDefaultGenerator();
        }
        int maxCapacity = 1000;
        int s1 = this.size();
        int s2 = other.size();
        DynamicFloatBin1D sample1 = new DynamicFloatBin1D();
        FloatBuffer buffer1 = sample1.buffered(Math.min(maxCapacity, s1));
        DynamicFloatBin1D sample2 = new DynamicFloatBin1D();
        FloatBuffer buffer2 = sample2.buffered(Math.min(maxCapacity, s2));
        DynamicFloatBin1D bootstrap = new DynamicFloatBin1D();
        FloatBuffer bootBuffer = bootstrap.buffered(Math.min(maxCapacity, resamples));
        int i = resamples;
        while (--i >= 0) {
            sample1.clear();
            sample2.clear();
            this.sample(s1, true, randomGenerator, buffer1);
            other.sample(s2, true, randomGenerator, buffer2);
            bootBuffer.add(function.apply(sample1, sample2));
        }
        bootBuffer.flush();
        return bootstrap;
    }

    public void setFixedOrder(boolean fixedOrder) {
        this.fixedOrder = fixedOrder;
    }

    public synchronized int size() {
        return this.elements.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            if (this.fixedOrder) {
                this.sortedElements.clear();
                this.sortedElements.addAllOfFromTo(this.elements, 0, this.elements.size() - 1);
                this.sortedElements.sort();
            } else {
                this.updateIncrementalStats();
                this.invalidateAll();
                this.elements.sort();
                this.isIncrementalStatValid = true;
            }
            this.isSorted = true;
        }
    }

    public synchronized FloatArrayList sortedElements() {
        return this.sortedElements_unsafe().copy();
    }

    protected synchronized FloatArrayList sortedElements_unsafe() {
        this.sort();
        if (this.fixedOrder) {
            return this.sortedElements;
        }
        return this.elements;
    }

    public synchronized void standardize(float mean, float standardDeviation) {
        FloatDescriptive.standardize(this.elements, mean, standardDeviation);
        this.clearAllMeasures();
        this.invalidateAll();
        this.size = 0;
    }

    public synchronized float sum() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum;
    }

    public synchronized float sumOfInversions() {
        if (!this.isSumOfInversionsValid) {
            this.updateSumOfInversions();
        }
        return this.sumOfInversions;
    }

    public synchronized float sumOfLogarithms() {
        if (!this.isSumOfLogarithmsValid) {
            this.updateSumOfLogarithms();
        }
        return this.sumOfLogarithms;
    }

    public synchronized float sumOfPowers(int k) {
        if (k >= -1 && k <= 2) {
            return super.sumOfPowers(k);
        }
        return FloatDescriptive.sumOfPowers(this.elements, k);
    }

    public synchronized float sumOfSquares() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum_xx;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        FloatArrayList distinctElements = new FloatArrayList();
        IntArrayList frequencies = new IntArrayList();
        this.frequencies(distinctElements, frequencies);
        if (distinctElements.size() < 100) {
            buf.append("Distinct elements: " + distinctElements + "\n");
            buf.append("Frequencies: " + frequencies + "\n");
        } else {
            buf.append("Distinct elements & frequencies not printed (too many).");
        }
        return buf.toString();
    }

    public synchronized void trim(int s, int l) {
        FloatArrayList elems = this.sortedElements();
        this.clear();
        this.addAllOfFromTo(elems, s, elems.size() - 1 - l);
    }

    public synchronized float trimmedMean(int s, int l) {
        return FloatDescriptive.trimmedMean(this.sortedElements_unsafe(), this.mean(), s, l);
    }

    public synchronized void trimToSize() {
        this.elements.trimToSize();
        this.sortedElements.clear();
        this.sortedElements.trimToSize();
        if (this.fixedOrder) {
            this.isSorted = false;
        }
    }

    protected void updateIncrementalStats() {
        float[] arguments = new float[]{this.min, this.max, this.sum, this.sum_xx};
        FloatDescriptive.incrementalUpdate(this.elements, this.size, this.elements.size() - 1, arguments);
        this.min = arguments[0];
        this.max = arguments[1];
        this.sum = arguments[2];
        this.sum_xx = arguments[3];
        this.isIncrementalStatValid = true;
        this.size = this.elements.size();
    }

    protected void updateSumOfInversions() {
        this.sumOfInversions = FloatDescriptive.sumOfInversions(this.elements, 0, this.size() - 1);
        this.isSumOfInversionsValid = true;
    }

    protected void updateSumOfLogarithms() {
        this.sumOfLogarithms = FloatDescriptive.sumOfLogarithms(this.elements, 0, this.size() - 1);
        this.isSumOfLogarithmsValid = true;
    }

    protected void validateAll() {
        this.isSorted = true;
        this.isIncrementalStatValid = true;
        this.isSumOfInversionsValid = true;
        this.isSumOfLogarithmsValid = true;
    }
}

