/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dsyrk;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlange;
import org.netlib.lapack.Dlansy;

public class DgelsTest {
    public static void main(String[] args) {
        int n = 10;
        int i = 0;
        while (i < n) {
            DgelsTest.dgelsTest(args);
            ++i;
        }
    }

    public static void dgelsTest(String[] args) {
        int j;
        if (args.length != 5) {
            System.out.println(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DgelsTest M N LDA NRHS LDB with \n - M : number of rows of the matrix A \n - N : number of columns of the matrix A \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the matrix B");
            System.exit(1);
        }
        int M = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        int LDA = Integer.parseInt(args[2]);
        int NRHS = Integer.parseInt(args[3]);
        int LDB = Integer.parseInt(args[4]);
        double[] A1 = new double[LDA * N];
        double[] A2 = new double[LDA * N];
        double[] Q = new double[M * M];
        double[] B1 = new double[LDB * NRHS];
        double[] B2 = new double[LDB * NRHS];
        Dplasma.plasma_Init(M, N, NRHS);
        int i = 0;
        while (i < M) {
            j = 0;
            while (j < N) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < M) {
            Q[M * i + i] = 1.0;
            ++i;
        }
        i = 0;
        while (i < M) {
            j = 0;
            while (j < NRHS) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
                ++j;
            }
            ++i;
        }
        double[] T = Dplasma.plasma_Allocate_T(M, N);
        Dplasma.plasma_DGELS(111, M, N, NRHS, A2, 0, LDA, T, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DORMQR(141, 111, M, M, N, A2, 0, LDA, T, 0, Q, 0, M);
        double eps = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGELS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", M, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int info_ortho = DgelsTest.check_orthogonality(M, Q, eps);
        int info_factorization = DgelsTest.check_factorization(M, N, A1, A2, LDA, Q, eps);
        int info_solution = DgelsTest.check_solution(M, N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0 & info_ortho == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGELS .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGELS .... FAILED !\n");
            System.out.print("************************************************\n");
        }
        i = 0;
        while (i < M) {
            j = 0;
            while (j < N) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
                ++j;
            }
            ++i;
        }
        Q = new double[M * M];
        i = 0;
        while (i < M) {
            Q[M * i + i] = 1.0;
            ++i;
        }
        i = 0;
        while (i < M) {
            j = 0;
            while (j < NRHS) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
                ++j;
            }
            ++i;
        }
        T = Dplasma.plasma_Allocate_T(M, N);
        Dplasma.plasma_DGEQRF(M, N, A2, 0, LDA, T, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DORMQR(141, 111, M, M, N, A2, 0, LDA, T, 0, Q, 0, M);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DORMQR(141, 111, M, NRHS, N, A2, 0, LDA, T, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DTRSM(141, 121, 111, 131, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGEQRF + DORMQR + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", M, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        info_ortho = DgelsTest.check_orthogonality(M, Q, eps);
        info_factorization = DgelsTest.check_factorization(M, N, A1, A2, LDA, Q, eps);
        info_solution = DgelsTest.check_solution(M, N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0 & info_ortho == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_orthogonality(int M, double[] Q, double eps) {
        int info_ortho;
        String norm = "I";
        double[] work = new double[M];
        double alpha = 1.0;
        double beta = -1.0;
        double[] Id2 = new double[M * M];
        int i = 0;
        while (i < M) {
            Id2[i * M + i] = 1.0;
            ++i;
        }
        Dsyrk.dsyrk("U", "N", M, M, alpha, Q, 0, M, beta, Id2, 0, M);
        double normQ = Dlansy.dlansy(norm, Dplasma.lapack_const(121), M, Id2, 0, M, work, 0);
        System.out.print("============\n");
        System.out.print("Checking the orthogonality of Q \n");
        System.out.print(String.format("||Id-Q'*Q||_oo / (N*eps) = %e\n", normQ / ((double)M * eps)));
        if (normQ / ((double)M * eps) > 10.0) {
            System.out.print("-- Orthogonality is suspicious ! \n");
            info_ortho = 1;
        } else {
            System.out.print("-- Orthogonality is CORRECT ! \n");
            info_ortho = 0;
        }
        return info_ortho;
    }

    private static int check_factorization(int M, int N, double[] A1, double[] A2, int LDA, double[] Q, double eps) {
        int info_factorization;
        String norm = "I";
        double[] Ql = new double[M * N];
        double[] Residual = new double[M * N];
        double[] work = new double[M];
        double alpha = 1.0;
        double beta = 0.0;
        double[] R = new double[M * N];
        Dlacpy.dlacpy("U", M, N, A2, 0, LDA, R, 0, M);
        Ql = new double[M * N];
        Dgemm.dgemm("T", "N", M, N, M, alpha, Q, 0, M, R, 0, M, beta, Ql, 0, M);
        int i = 0;
        while (i < M) {
            int j = 0;
            while (j < N) {
                Residual[j * M + i] = A1[j * LDA + i] - Ql[j * M + i];
                ++j;
            }
            ++i;
        }
        double Rnorm = Dlange.dlange(norm, M, N, Residual, 0, M, work, 0);
        double Anorm = Dlange.dlange(norm, M, N, A2, 0, LDA, work, 0);
        System.out.print("============\n");
        System.out.print("Checking the QR Factorization \n");
        System.out.print(String.format("-- ||A-QR||_oo/(||A||_oo.N.eps) = %e \n", Rnorm / (Anorm * (double)N * eps)));
        if (Rnorm / (Anorm * (double)N * eps) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            info_factorization = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            info_factorization = 0;
        }
        return info_factorization;
    }

    private static int check_solution(int M, int N, int NRHS, double[] A1, int LDA, double[] B1, double[] B2, int LDB, double eps) {
        int info_solution;
        String norm = "I";
        double[] work = new double[M];
        double alpha = 1.0;
        double beta = -1.0;
        double Anorm = Dlange.dlange(norm, M, N, A1, 0, LDA, work, 0);
        double Xnorm = Dlange.dlange(norm, M, NRHS, B2, 0, LDB, work, 0);
        double Bnorm = Dlange.dlange(norm, M, NRHS, B1, 0, LDB, work, 0);
        Dgemm.dgemm("N", "N", M, NRHS, N, alpha, A1, 0, LDA, B2, 0, LDB, beta, B1, 0, LDB);
        double[] Residual = new double[M * NRHS];
        Dgemm.dgemm("T", "N", N, NRHS, M, alpha, A1, 0, LDA, B1, 0, LDB, beta, Residual, 0, M);
        double Rnorm = Dlange.dlange(norm, M, NRHS, Residual, 0, M, work, 0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||)_oo.N.eps) = %e \n", Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps)));
        if (Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            info_solution = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            info_solution = 0;
        }
        return info_solution;
    }
}

