/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.DbdlConvert;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.Pdgelqf;
import edu.emory.mathcs.jplasma.tdouble.Pdgeqrf;
import edu.emory.mathcs.jplasma.tdouble.Pdormqr;
import edu.emory.mathcs.jplasma.tdouble.Pdtrsm;
import java.util.concurrent.locks.Lock;

class Dgels {
    private Dgels() {
    }

    protected static int plasma_DGELS(int trans, int M, int N, int NRHS, double[] A, int A_offset, int LDA, double[] T, int T_offset, double[] B, int B_offset, int LDB) {
        double[] bdl_mem;
        int size_elems;
        int NTRHS;
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_DGELS", "PLASMA not initialized");
            return -1;
        }
        if (trans != 111) {
            Dauxiliary.plasma_error("plasma_DGELS", "only PlasmaNoTrans supported");
            return -3;
        }
        if (M < 0) {
            Dauxiliary.plasma_error("plasma_DGELS", "illegal value of M");
            return -4;
        }
        if (N < 0) {
            Dauxiliary.plasma_error("plasma_DGELS", "illegal value of N");
            return -4;
        }
        if (NRHS < 0) {
            Dauxiliary.plasma_error("plasma_DGELS", "illegal value of NRHS");
            return -4;
        }
        if (LDA < Math.max(1, M)) {
            Dauxiliary.plasma_error("plasma_DGELS", "illegal value of LDA");
            return -4;
        }
        if (LDB < Math.max(1, Math.max(M, N))) {
            Dauxiliary.plasma_error("plasma_DGELS", "illegal value of LDB");
            return -4;
        }
        if (Math.min(M, Math.min(N, NRHS)) == 0) {
            return 0;
        }
        int status = Dauxiliary.plasma_tune(1, M, N, NRHS);
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_DGELS", "plasma_tune() failed");
            return status;
        }
        int NB = Dcommon.plasma_cntrl.NB;
        int NT = N % NB == 0 ? N / NB : N / NB + 1;
        int MT = M % NB == 0 ? M / NB : M / NB + 1;
        int n = NTRHS = NRHS % NB == 0 ? NRHS / NB : NRHS / NB + 1;
        if (Dcommon.plasma_cntrl.NB > Dcommon.plasma_cntrl.NB_max) {
            status = Dallocate.plasma_free_aux_work_tau();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGELS", "plasma_free_aux_work_tau() failed");
                return status;
            }
            Dcommon.plasma_cntrl.NB_max = Dcommon.plasma_cntrl.NB;
            status = Dallocate.plasma_alloc_aux_work_tau();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGELS", "plasma_alloc_aux_work_tau() failed");
                return status;
            }
        }
        if (Dcommon.plasma_cntrl.progress_size_elems < (size_elems = Math.max(MT, NT) * Math.max(NT, NTRHS))) {
            status = Dallocate.plasma_free_aux_progress();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGELS", "plasma_free_aux_progress() failed");
            }
            if ((status = Dallocate.plasma_alloc_aux_progress(size_elems)) != 0) {
                Dauxiliary.plasma_error("plasma_DGELS", "plasma_alloc_aux_progress() failed");
                return status;
            }
        }
        double[] Abdl = bdl_mem = Dcommon.plasma_aux.bdl_mem;
        int Abdl_offset = 0;
        double[] Tbdl = bdl_mem;
        int Tbdl_offset = MT * NT * Dcommon.plasma_cntrl.NBNBSIZE;
        double[] Bbdl = bdl_mem;
        int Bbdl_offset = Tbdl_offset + MT * NT * Dcommon.plasma_cntrl.IBNBSIZE;
        size_elems = Bbdl_offset + Math.max(MT, NT) * NTRHS * Dcommon.plasma_cntrl.NBNBSIZE;
        if (Dcommon.plasma_cntrl.bdl_size_elems < size_elems) {
            status = Dallocate.plasma_free_aux_bdl();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGELS", "plasma_free_aux_bdl() failed");
                return status;
            }
            status = Dallocate.plasma_alloc_aux_bdl(size_elems);
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DGELS", "plasma_alloc_aux_bdl() failed");
                return status;
            }
            Abdl = bdl_mem = Dcommon.plasma_aux.bdl_mem;
            Abdl_offset = 0;
            Tbdl = bdl_mem;
            Tbdl_offset = MT * NT * Dcommon.plasma_cntrl.NBNBSIZE;
            Bbdl = bdl_mem;
            Bbdl_offset = Tbdl_offset + MT * NT * Dcommon.plasma_cntrl.IBNBSIZE;
        }
        if (M >= N) {
            Dcommon.plasma_args.F77 = A;
            Dcommon.plasma_args.F77_offset = A_offset;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.LDA = LDA;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Lock lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 9;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.F77 = B;
            Dcommon.plasma_args.F77_offset = B_offset;
            Dcommon.plasma_args.A = Bbdl;
            Dcommon.plasma_args.A_offset = Bbdl_offset;
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = NRHS;
            Dcommon.plasma_args.LDA = LDB;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NT = NTRHS;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 9;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.IBNBSIZE = Dcommon.plasma_cntrl.IBNBSIZE;
            Dcommon.plasma_args.IB = Dcommon.plasma_cntrl.IB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.T = Tbdl;
            Dcommon.plasma_args.T_offset = Tbdl_offset;
            Dauxiliary.plasma_clear_aux_progress(MT * NT, -1);
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 2;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdgeqrf.plasma_pDGEQRF(Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.IBNBSIZE, Dcommon.plasma_args.IB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.T, Dcommon.plasma_args.T_offset, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            System.arraycopy(Tbdl, Tbdl_offset, T, T_offset, MT * NT * Dcommon.plasma_cntrl.IBNBSIZE);
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.NRHS = NRHS;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.IBNBSIZE = Dcommon.plasma_cntrl.IBNBSIZE;
            Dcommon.plasma_args.IB = Dcommon.plasma_cntrl.IB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NTRHS = NTRHS;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.T = Tbdl;
            Dcommon.plasma_args.T_offset = Tbdl_offset;
            Dcommon.plasma_args.B = Bbdl;
            Dcommon.plasma_args.B_offset = Bbdl_offset;
            Dauxiliary.plasma_clear_aux_progress(MT * NTRHS, -1);
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 3;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdormqr.plasma_pDORMQR(Dcommon.plasma_args.M, Dcommon.plasma_args.NRHS, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.IBNBSIZE, Dcommon.plasma_args.IB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NTRHS, Dcommon.plasma_args.NT, Dcommon.plasma_args.T, Dcommon.plasma_args.T_offset, Dcommon.plasma_args.B, Dcommon.plasma_args.B_offset, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.uplo = 121;
            Dcommon.plasma_args.trans = 111;
            Dcommon.plasma_args.diag = 131;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.NRHS = NRHS;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.B = Bbdl;
            Dcommon.plasma_args.B_offset = Bbdl_offset;
            Dcommon.plasma_args.MTB = MT;
            Dcommon.plasma_args.NTRHS = NTRHS;
            Dauxiliary.plasma_clear_aux_progress(NT * NTRHS, -1);
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 4;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdtrsm.plasma_pDTRSM(141, Dcommon.plasma_args.uplo, Dcommon.plasma_args.trans, Dcommon.plasma_args.diag, Dcommon.plasma_args.N, Dcommon.plasma_args.NRHS, 1.0, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.NT, Dcommon.plasma_args.MT, Dcommon.plasma_args.B, Dcommon.plasma_args.B_offset, Dcommon.plasma_args.MTB, Dcommon.plasma_args.NTRHS, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.F77 = A;
            Dcommon.plasma_args.F77_offset = A_offset;
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.LDA = LDA;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 10;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.A = Bbdl;
            Dcommon.plasma_args.A_offset = Bbdl_offset;
            Dcommon.plasma_args.F77 = B;
            Dcommon.plasma_args.F77_offset = B_offset;
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = NRHS;
            Dcommon.plasma_args.LDA = LDB;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NT = NTRHS;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 10;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        } else {
            DbdlConvert.plasma_lapack_to_bdl(A, A_offset, Abdl, Abdl_offset, M, N, LDA, Dcommon.plasma_cntrl.NB, MT, NT, Dcommon.plasma_cntrl.NBNBSIZE, 1, 0);
            DbdlConvert.plasma_lapack_to_bdl(B, B_offset, Bbdl, Bbdl_offset, N, NRHS, LDB, Dcommon.plasma_cntrl.NB, NT, NTRHS, Dcommon.plasma_cntrl.NBNBSIZE, 1, 0);
            Dcommon.plasma_args.M = M;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.IBNBSIZE = Dcommon.plasma_cntrl.IBNBSIZE;
            Dcommon.plasma_args.IB = Dcommon.plasma_cntrl.IB;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.T = Tbdl;
            Dcommon.plasma_args.T_offset = Tbdl_offset;
            Dauxiliary.plasma_clear_aux_progress(MT * NT, -1);
            Lock lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 6;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdgelqf.plasma_pDGELQF(Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.IBNBSIZE, Dcommon.plasma_args.IB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.T, Dcommon.plasma_args.T_offset, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.uplo = 122;
            Dcommon.plasma_args.trans = 111;
            Dcommon.plasma_args.diag = 131;
            Dcommon.plasma_args.N = M;
            Dcommon.plasma_args.NRHS = NRHS;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.NT = MT;
            Dcommon.plasma_args.MT = MT;
            Dcommon.plasma_args.B = Bbdl;
            Dcommon.plasma_args.B_offset = Bbdl_offset;
            Dcommon.plasma_args.MTB = NT;
            Dcommon.plasma_args.NTRHS = NTRHS;
            Dauxiliary.plasma_clear_aux_progress(MT * NTRHS, -1);
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 4;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdtrsm.plasma_pDTRSM(141, Dcommon.plasma_args.uplo, Dcommon.plasma_args.trans, Dcommon.plasma_args.diag, Dcommon.plasma_args.N, Dcommon.plasma_args.NRHS, 1.0, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.NT, Dcommon.plasma_args.MT, Dcommon.plasma_args.B, Dcommon.plasma_args.B_offset, Dcommon.plasma_args.MTB, Dcommon.plasma_args.NTRHS, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            DbdlConvert.plasma_bdl_to_lapack(Abdl, Abdl_offset, A, A_offset, M, N, LDA, Dcommon.plasma_cntrl.NB, MT, NT, Dcommon.plasma_cntrl.NBNBSIZE, 1, 0);
            DbdlConvert.plasma_bdl_to_lapack(Bbdl, Bbdl_offset, B, B_offset, N, NRHS, LDB, Dcommon.plasma_cntrl.NB, NT, NTRHS, Dcommon.plasma_cntrl.NBNBSIZE, 1, 0);
        }
        return 0;
    }
}

