/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tfloat;

import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_spsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_util;

public class Scs_lu {
    public static Scs_common.Scsn cs_lu(Scs_common.Scs A, Scs_common.Scss S, float tol) {
        int p;
        int[] Li;
        int k;
        int i;
        Scs_common.Scs U;
        Scs_common.Scs L;
        if (!Scs_util.CS_CSC(A) || S == null) {
            return null;
        }
        int n = A.n;
        int[] q = S.q;
        int lnz = S.lnz;
        int unz = S.unz;
        float[] x = new float[n];
        int[] xi = new int[2 * n];
        Scs_common.Scsn N = new Scs_common.Scsn();
        N.L = L = Scs_util.cs_spalloc(n, n, lnz, true, false);
        N.U = U = Scs_util.cs_spalloc(n, n, unz, true, false);
        int[] pinv = new int[n];
        N.pinv = pinv;
        int[] Lp = L.p;
        int[] Up = U.p;
        for (i = 0; i < n; ++i) {
            x[i] = 0.0f;
        }
        for (i = 0; i < n; ++i) {
            pinv[i] = -1;
        }
        for (k = 0; k <= n; ++k) {
            Lp[k] = 0;
        }
        unz = 0;
        lnz = 0;
        for (k = 0; k < n; ++k) {
            Lp[k] = lnz;
            Up[k] = unz;
            if (lnz + n > L.nzmax) {
                Scs_util.cs_sprealloc(L, 2 * L.nzmax + n);
            }
            if (unz + n > U.nzmax) {
                Scs_util.cs_sprealloc(U, 2 * U.nzmax + n);
            }
            Li = L.i;
            float[] Lx = L.x;
            int[] Ui = U.i;
            float[] Ux = U.x;
            int col = q != null ? q[k] : k;
            int top = Scs_spsolve.cs_spsolve(L, A, col, xi, x, pinv, true);
            int ipiv = -1;
            float a = -1.0f;
            for (p = top; p < n; ++p) {
                i = xi[p];
                if (pinv[i] < 0) {
                    float f;
                    float t = Math.abs(x[i]);
                    if (!(f > a)) continue;
                    a = t;
                    ipiv = i;
                    continue;
                }
                Ui[unz] = pinv[i];
                Ux[unz++] = x[i];
            }
            if (ipiv == -1 || a <= 0.0f) {
                return null;
            }
            if (pinv[col] < 0 && Math.abs(x[col]) >= a * tol) {
                ipiv = col;
            }
            float pivot = x[ipiv];
            Ui[unz] = k;
            Ux[unz++] = pivot;
            pinv[ipiv] = k;
            Li[lnz] = ipiv;
            Lx[lnz++] = 1.0f;
            for (p = top; p < n; ++p) {
                i = xi[p];
                if (pinv[i] < 0) {
                    Li[lnz] = i;
                    Lx[lnz++] = x[i] / pivot;
                }
                x[i] = 0.0f;
            }
        }
        Lp[n] = lnz;
        Up[n] = unz;
        Li = L.i;
        for (p = 0; p < lnz; ++p) {
            Li[p] = pinv[Li[p]];
        }
        Scs_util.cs_sprealloc(L, 0);
        Scs_util.cs_sprealloc(U, 0);
        return N;
    }
}

