/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

class FloatQuantileCalc {
    FloatQuantileCalc() {
    }

    public static float binomial(long n, long k) {
        if (k == 0L || k == n) {
            return 1.0f;
        }
        if ((double)k > (double)n / 2.0) {
            k = n - k;
        }
        float binomial = 1.0f;
        long N = n - k + 1L;
        long i = k;
        while (i > 0L) {
            binomial *= (float)N++ / (float)i--;
        }
        return binomial;
    }

    public static long ceiling(float value) {
        return Math.round(Math.ceil(value));
    }

    public static long[] known_N_compute_B_and_K(long N, float epsilon, float delta, int quantiles, float[] returnSamplingRate) {
        if ((double)delta > 0.0) {
            return FloatQuantileCalc.known_N_compute_B_and_K_slow(N, epsilon, delta, quantiles, returnSamplingRate);
        }
        returnSamplingRate[0] = 1.0f;
        return FloatQuantileCalc.known_N_compute_B_and_K_quick(N, epsilon);
    }

    protected static long[] known_N_compute_B_and_K_quick(long N, float epsilon) {
        long k;
        long b;
        if ((double)epsilon <= 0.0) {
            long[] result = new long[]{1L, N};
            return result;
        }
        int maxBuffers = 50;
        int maxHeight = 50;
        float N_float = N;
        float c = N_float * epsilon * 2.0f;
        int[] heightMaximums = new int[49];
        for (int b2 = 2; b2 <= 50; ++b2) {
            int h;
            for (h = 3; h <= 50 && (double)((float)(h - 2) * (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 2, h - 1)) - (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 3, h - 3)) + (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 3, h - 2)) - c) > 0.0; ++h) {
            }
            while (h <= 50 && (double)((float)(h - 2) * (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 2, h - 1)) - (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 3, h - 3)) + (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 3, h - 2)) - c) <= 0.0) {
                ++h;
            }
            int hMax = --h >= 50 && (double)((float)(h - 2) * (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 2, h - 1)) - (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 3, h - 3)) + (float)Math.round(FloatQuantileCalc.binomial(b2 + h - 3, h - 2)) - c) > 0.0 ? Integer.MIN_VALUE : h;
            heightMaximums[b2 - 2] = hMax;
        }
        long[] kMinimums = new long[49];
        for (int b3 = 2; b3 <= 50; ++b3) {
            float value;
            long tmpK;
            int h = heightMaximums[b3 - 2];
            long kMin = Long.MAX_VALUE;
            if (h > Integer.MIN_VALUE && (tmpK = FloatQuantileCalc.ceiling(N_float / (value = (float)Math.round(FloatQuantileCalc.binomial(b3 + h - 2, h - 1))))) <= Long.MAX_VALUE) {
                kMin = tmpK;
            }
            kMinimums[b3 - 2] = kMin;
        }
        long multMin = Long.MAX_VALUE;
        int minB = -1;
        for (int b4 = 2; b4 <= 50; ++b4) {
            long mult;
            if (kMinimums[b4 - 2] >= Long.MAX_VALUE || (mult = (long)b4 * kMinimums[b4 - 2]) >= multMin) continue;
            multMin = mult;
            minB = b4;
        }
        if (minB != -1) {
            b = minB;
            k = kMinimums[minB - 2];
        } else {
            b = 1L;
            k = N;
        }
        long[] result = new long[]{b, k};
        return result;
    }

    protected static long[] known_N_compute_B_and_K_slow(long N, float epsilon, float delta, int quantiles, float[] returnSamplingRate) {
        if ((double)epsilon <= 0.0) {
            long[] result = new long[]{1L, N};
            returnSamplingRate[0] = 1.0f;
            return result;
        }
        int maxBuffers = 50;
        int maxHeight = 50;
        float N_float = N;
        long ret_b = 1L;
        long ret_k = N;
        float sampling_rate = 1.0f;
        long memory = N;
        float logarithm = (float)Math.log(2.0 * (double)quantiles / (double)delta);
        float c = 2.0f * epsilon * N_float;
        for (long b = 2L; b < 50L; ++b) {
            for (long h = 3L; h < 50L; ++h) {
                float binomial = FloatQuantileCalc.binomial(b + h - 2L, h - 1L);
                long tmp = FloatQuantileCalc.ceiling(N_float / binomial);
                if (b * tmp < memory && (float)(h - 2L) * binomial - FloatQuantileCalc.binomial(b + h - 3L, h - 3L) + FloatQuantileCalc.binomial(b + h - 3L, h - 2L) <= c) {
                    ret_k = tmp;
                    ret_b = b;
                    memory = ret_k * b;
                    sampling_rate = 1.0f;
                }
                if (!((double)delta > 0.0)) continue;
                float t = (float)(h - 2L) * FloatQuantileCalc.binomial(b + h - 2L, h - 1L) - FloatQuantileCalc.binomial(b + h - 3L, h - 3L) + FloatQuantileCalc.binomial(b + h - 3L, h - 2L);
                float u = logarithm / epsilon;
                float v = FloatQuantileCalc.binomial(b + h - 2L, h - 1L);
                float w = (float)((double)logarithm / (2.0 * (double)epsilon * (double)epsilon));
                float x = (float)(0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * (double)t / (double)u));
                long k = FloatQuantileCalc.ceiling(w * x * x / v);
                if (b * k >= memory) continue;
                ret_k = k;
                ret_b = b;
                memory = b * k;
                sampling_rate = (float)((double)N_float * 2.0 * (double)epsilon * (double)epsilon / (double)logarithm);
            }
        }
        long[] result = new long[]{ret_b, ret_k};
        returnSamplingRate[0] = sampling_rate;
        return result;
    }

    public static void main(String[] args) {
        FloatQuantileCalc.test_B_and_K_Calculation(args);
    }

    public static void test_B_and_K_Calculation(String[] args) {
        boolean known_N = args == null ? false : new Boolean(args[0]);
        int[] quantiles = new int[]{1, 1000};
        long[] sizes = new long[]{100000L, 1000000L, 10000000L, 1000000000L};
        float[] deltas = new float[]{0.0f, 0.001f, 1.0E-4f, 1.0E-5f};
        float[] epsilons = new float[]{0.0f, 0.1f, 0.05f, 0.01f, 0.005f, 0.001f, 1.0E-7f};
        if (!known_N) {
            sizes = new long[]{0L};
        }
        System.out.println("\n\n");
        if (known_N) {
            System.out.println("Computing b's and k's for KNOWN N");
        } else {
            System.out.println("Computing b's and k's for UNKNOWN N");
        }
        System.out.println("mem [elements/1024]");
        System.out.println("***********************************");
        for (int q = 0; q < quantiles.length; ++q) {
            int p = quantiles[q];
            System.out.println("------------------------------");
            System.out.println("computing for p = " + p);
            for (int s = 0; s < sizes.length; ++s) {
                long N = sizes[s];
                System.out.println("   ------------------------------");
                System.out.println("   computing for N = " + N);
                for (int d = 0; d < deltas.length; ++d) {
                    float delta = deltas[d];
                    System.out.println("      ------------------------------");
                    System.out.println("      computing for delta = " + delta);
                    for (int e = 0; e < epsilons.length; ++e) {
                        float epsilon = epsilons[e];
                        float[] returnSamplingRate = new float[1];
                        long[] result = known_N ? FloatQuantileCalc.known_N_compute_B_and_K(N, epsilon, delta, p, returnSamplingRate) : FloatQuantileCalc.unknown_N_compute_B_and_K(epsilon, delta, p);
                        long b = result[0];
                        long k = result[1];
                        System.out.print("         (e,d,N,p)=(" + epsilon + "," + delta + "," + N + "," + p + ") --> ");
                        System.out.print("(b,k,mem");
                        if (known_N) {
                            System.out.print(",sampling");
                        }
                        System.out.print(")=(" + b + "," + k + "," + b * k / 1024L);
                        if (known_N) {
                            System.out.print("," + returnSamplingRate[0]);
                        }
                        System.out.println(")");
                    }
                }
            }
        }
    }

    public static long[] unknown_N_compute_B_and_K(float epsilon, float delta, int quantiles) {
        if ((double)epsilon <= 0.0 || (double)delta <= 0.0) {
            long[] result = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE};
            return result;
        }
        int max_b = 50;
        int max_h = 50;
        int max_H = 50;
        int max_Iterations = 2;
        long best_b = Long.MAX_VALUE;
        long best_k = Long.MAX_VALUE;
        long best_h = Long.MAX_VALUE;
        long best_memory = Long.MAX_VALUE;
        float pow = (float)Math.pow(2.0, max_H);
        float logDelta = (float)(Math.log(2.0 / (double)(delta / (float)quantiles)) / (2.0 * (double)epsilon * (double)epsilon));
        while (best_b == Long.MAX_VALUE && max_Iterations-- > 0) {
            for (int b = 2; b <= max_b; ++b) {
                for (int h = 2; h <= max_h; ++h) {
                    long memory;
                    float beta;
                    float cc;
                    float d;
                    float Ls;
                    float Ld = FloatQuantileCalc.binomial(b + h - 2, h - 1);
                    float c = (float)((double)logDelta / Math.min((double)Ld, 8.0 * (double)(Ls = FloatQuantileCalc.binomial(b + h - 3, h - 1)) / 3.0));
                    float f = c * c + 4.0f * c * (d = (float)((double)((float)(h + 3) + (cc = (float)(((double)(beta = Ld / Ls) - 2.0) * ((double)max_H - 2.0) / ((double)(beta + pow) - 2.0)))) / (2.0 * (double)epsilon)));
                    if ((double)f < 0.0) continue;
                    float root = (float)Math.sqrt(f);
                    float alpha_one = (float)(((double)c + 2.0 * (double)d + (double)root) / (2.0 * (double)d));
                    float alpha_two = (float)(((double)c + 2.0 * (double)d - (double)root) / (2.0 * (double)d));
                    boolean alpha_one_OK = false;
                    boolean alpha_two_OK = false;
                    if (0.0 < (double)alpha_one && (double)alpha_one < 1.0) {
                        alpha_one_OK = true;
                    }
                    if (0.0 < (double)alpha_two && (double)alpha_two < 1.0) {
                        alpha_two_OK = true;
                    }
                    if (!alpha_one_OK && !alpha_two_OK) continue;
                    float alpha = alpha_one;
                    if (alpha_one_OK && alpha_two_OK) {
                        alpha = Math.max(alpha_one, alpha_two);
                    } else if (alpha_two_OK) {
                        alpha = alpha_two;
                    }
                    long k = FloatQuantileCalc.ceiling((float)Math.max((double)(d / alpha), (double)(h + 1) / (2.0 * (double)epsilon)));
                    if (k <= 0L || (memory = (long)b * k) >= best_memory) continue;
                    best_k = k;
                    best_b = b;
                    best_h = h;
                    best_memory = memory;
                }
            }
            if (best_b != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            max_b *= 2;
            max_h *= 2;
            max_H *= 2;
        }
        long[] result = new long[3];
        if (best_b == Long.MAX_VALUE) {
            result[0] = 1L;
            result[1] = Long.MAX_VALUE;
            result[2] = Long.MAX_VALUE;
        } else {
            result[0] = best_b;
            result[1] = best_k;
            result[2] = best_h;
        }
        return result;
    }
}

