/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.function.tfloat.FloatProcedure;
import cern.jet.stat.BufferSet;
import cern.jet.stat.tfloat.quantile.FloatBuffer;

class FloatBufferSet
extends BufferSet {
    private static final long serialVersionUID = 1L;
    protected FloatBuffer[] buffers;
    private boolean nextTriggerCalculationState;

    public FloatBufferSet(int b, int k) {
        this.buffers = new FloatBuffer[b];
        this.clear(k);
    }

    public FloatBuffer _getFirstEmptyBuffer() {
        FloatBuffer emptyBuffer = null;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isEmpty()) continue;
            if (this.buffers[i].isAllocated()) {
                return this.buffers[i];
            }
            emptyBuffer = this.buffers[i];
        }
        return emptyBuffer;
    }

    public FloatBuffer[] _getFullOrPartialBuffers() {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty()) continue;
            ++count;
        }
        FloatBuffer[] collectedBuffers = new FloatBuffer[count];
        int j = 0;
        int i2 = this.buffers.length;
        while (--i2 >= 0) {
            if (this.buffers[i2].isEmpty()) continue;
            collectedBuffers[j++] = this.buffers[i2];
        }
        return collectedBuffers;
    }

    public FloatBuffer[] _getFullOrPartialBuffersWithLevel(int level) {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty() || this.buffers[i].level() != level) continue;
            ++count;
        }
        FloatBuffer[] collectedBuffers = new FloatBuffer[count];
        int j = 0;
        int i2 = this.buffers.length;
        while (--i2 >= 0) {
            if (this.buffers[i2].isEmpty() || this.buffers[i2].level() != level) continue;
            collectedBuffers[j++] = this.buffers[i2];
        }
        return collectedBuffers;
    }

    public int _getMinLevelOfFullOrPartialBuffers() {
        int b = this.b();
        int minLevel = Integer.MAX_VALUE;
        for (int i = 0; i < b; ++i) {
            FloatBuffer buffer = this.buffers[i];
            if (buffer.isEmpty() || buffer.level() >= minLevel) continue;
            minLevel = buffer.level();
        }
        return minLevel;
    }

    public int _getNumberOfEmptyBuffers() {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public FloatBuffer _getPartialBuffer() {
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isPartial()) continue;
            return this.buffers[i];
        }
        return null;
    }

    public int b() {
        return this.buffers.length;
    }

    public void clear() {
        this.clear(this.k());
    }

    protected void clear(int k) {
        int i = this.b();
        while (--i >= 0) {
            this.buffers[i] = new FloatBuffer(k);
        }
        this.nextTriggerCalculationState = true;
    }

    public Object clone() {
        FloatBufferSet copy = (FloatBufferSet)super.clone();
        copy.buffers = (FloatBuffer[])copy.buffers.clone();
        int i = this.buffers.length;
        while (--i >= 0) {
            copy.buffers[i] = (FloatBuffer)copy.buffers[i].clone();
        }
        return copy;
    }

    public FloatBuffer collapse(FloatBuffer[] buffers) {
        int W = 0;
        for (int i = 0; i < buffers.length; ++i) {
            W += buffers[i].weight();
        }
        int k = this.k();
        long[] triggerPositions = new long[k];
        for (int j = 0; j < k; ++j) {
            triggerPositions[j] = this.nextTriggerPosition(j, W);
        }
        float[] outputValues = this.getValuesAtPositions(buffers, triggerPositions);
        for (int b = 1; b < buffers.length; ++b) {
            buffers[b].clear();
        }
        FloatBuffer outputBuffer = buffers[0];
        outputBuffer.values.elements(outputValues);
        outputBuffer.weight(W);
        return outputBuffer;
    }

    public boolean contains(float element) {
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty() || !this.buffers[i].contains(element)) continue;
            return true;
        }
        return false;
    }

    public boolean forEach(FloatProcedure procedure) {
        int i = this.buffers.length;
        while (--i >= 0) {
            int w = this.buffers[i].weight();
            while (--w >= 0) {
                if (this.buffers[i].values.forEach(procedure)) continue;
                return false;
            }
        }
        return true;
    }

    protected float[] getValuesAtPositions(FloatBuffer[] buffers, long[] triggerPositions) {
        int i = buffers.length;
        while (--i >= 0) {
            buffers[i].sort();
        }
        int[] bufferSizes = new int[buffers.length];
        float[][] bufferValues = new float[buffers.length][];
        int totalBuffersSize = 0;
        int i2 = buffers.length;
        while (--i2 >= 0) {
            bufferSizes[i2] = buffers[i2].size();
            bufferValues[i2] = buffers[i2].values.elements();
            totalBuffersSize += bufferSizes[i2];
        }
        int buffersSize = buffers.length;
        int triggerPositionsLength = triggerPositions.length;
        int j = 0;
        int[] cursors = new int[buffers.length];
        long counter = 0L;
        long nextHit = triggerPositions[j];
        float[] outputValues = new float[triggerPositionsLength];
        if (totalBuffersSize == 0) {
            for (int i3 = 0; i3 < triggerPositions.length; ++i3) {
                outputValues[i3] = Float.NaN;
            }
            return outputValues;
        }
        while (j < triggerPositionsLength) {
            float minValue = Float.POSITIVE_INFINITY;
            int minBufferIndex = -1;
            int b = buffersSize;
            while (--b >= 0) {
                float value;
                if (cursors[b] >= bufferSizes[b] || !((value = bufferValues[b][cursors[b]]) <= minValue)) continue;
                minValue = value;
                minBufferIndex = b;
            }
            FloatBuffer minBuffer = buffers[minBufferIndex];
            counter += (long)minBuffer.weight();
            while (counter > nextHit && j < triggerPositionsLength) {
                outputValues[j++] = minValue;
                if (j >= triggerPositionsLength) continue;
                nextHit = triggerPositions[j];
            }
            int n = minBufferIndex;
            cursors[n] = cursors[n] + 1;
        }
        return outputValues;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long memory = 0L;
        int i = this.buffers.length;
        while (--i >= 0) {
            memory += (long)this.buffers[i].memory();
        }
        return memory;
    }

    protected long nextTriggerPosition(int j, long W) {
        long nextTriggerPosition = W % 2L != 0L ? (long)j * W + (W + 1L) / 2L : (this.nextTriggerCalculationState ? (long)j * W + W / 2L : (long)j * W + (W + 2L) / 2L);
        return nextTriggerPosition;
    }

    public float phi(float element) {
        float elementsLessThanOrEqualToElement = 0.0f;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty()) continue;
            elementsLessThanOrEqualToElement += (float)this.buffers[i].weight * this.buffers[i].rank(element);
        }
        return elementsLessThanOrEqualToElement / (float)this.totalSize();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int b = 0; b < this.b(); ++b) {
            if (this.buffers[b].isEmpty()) continue;
            buf.append("buffer#" + b + " = ");
            buf.append(this.buffers[b].toString() + "\n");
        }
        return buf.toString();
    }

    public long totalSize() {
        FloatBuffer[] fullBuffers = this._getFullOrPartialBuffers();
        long totalSize = 0L;
        int i = fullBuffers.length;
        while (--i >= 0) {
            totalSize += (long)(fullBuffers[i].size() * fullBuffers[i].weight());
        }
        return totalSize;
    }
}

