/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.stat.tdouble.DoubleDescriptive;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinder;

public class ExactDoubleQuantileFinder
extends PersistentObject
implements DoubleQuantileFinder {
    private static final long serialVersionUID = 1L;
    public DoubleArrayList buffer = new DoubleArrayList(0);
    public boolean isSorted;

    public ExactDoubleQuantileFinder() {
        this.clear();
    }

    public void add(double value) {
        this.buffer.add(value);
        this.isSorted = false;
    }

    public void addAllOf(DoubleArrayList values) {
        this.addAllOfFromTo(values, 0, values.size() - 1);
    }

    public void addAllOfFromTo(DoubleArrayList values, int from, int to) {
        this.buffer.addAllOfFromTo(values, from, to);
        this.isSorted = false;
    }

    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    public Object clone() {
        ExactDoubleQuantileFinder copy = (ExactDoubleQuantileFinder)super.clone();
        if (this.buffer != null) {
            copy.buffer = copy.buffer.copy();
        }
        return copy;
    }

    public boolean contains(double element) {
        this.sort();
        return this.buffer.binarySearch(element) >= 0;
    }

    public boolean forEach(DoubleProcedure procedure) {
        double[] theElements = this.buffer.elements();
        int theSize = (int)this.size();
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public long memory() {
        return this.buffer.elements().length;
    }

    public double phi(double element) {
        this.sort();
        return DoubleDescriptive.rankInterpolated(this.buffer, element) / (double)this.size();
    }

    public DoubleArrayList quantileElements(DoubleArrayList phis) {
        this.sort();
        return DoubleDescriptive.quantiles(this.buffer, phis);
    }

    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        return s + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    public long totalMemory() {
        return this.memory();
    }
}

