/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble.engine;

import cern.colt.PersistentObject;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tlong.LongFunction;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;

public abstract class DoubleRandomEngine
extends PersistentObject
implements DoubleFunction,
IntFunction,
LongFunction {
    private static final long serialVersionUID = 1L;

    protected DoubleRandomEngine() {
    }

    public double apply(double dummy) {
        return this.raw();
    }

    public int apply(int dummy) {
        return this.nextInt();
    }

    public long apply(long dummy) {
        return this.nextLong();
    }

    public static DoubleRandomEngine makeDefault() {
        return new DoubleMersenneTwister((int)System.currentTimeMillis());
    }

    public double nextDouble() {
        double nextDouble;
        while (!((nextDouble = ((double)this.nextLong() - -9.223372036854776E18) * 5.421010862427522E-20) > 0.0) || !(nextDouble < 1.0)) {
        }
        return nextDouble;
    }

    public float nextFloat() {
        float nextFloat;
        while ((nextFloat = (float)this.raw()) >= 1.0f) {
        }
        return nextFloat;
    }

    public abstract int nextInt();

    public long nextLong() {
        return ((long)this.nextInt() & 0xFFFFFFFFL) << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    public double raw() {
        int nextInt;
        while ((nextInt = this.nextInt()) == 0) {
        }
        return (double)((long)nextInt & 0xFFFFFFFFL) * 2.3283064365386963E-10;
    }
}

