/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix3D;

class SelectedSparseIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseIntMatrix3D(AbstractLongIntMap elements, int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets, int offset) {
        int slices = sliceOffsets.length;
        int rows = rowOffsets.length;
        int columns = columnOffsets.length;
        this.setUp(slices, rows, columns);
        this.elements = elements;
        this.sliceOffsets = sliceOffsets;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public AbstractLongIntMap elements() {
        return this.elements;
    }

    public int getQuick(int slice, int row, int column) {
        return this.elements.get((long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride]);
    }

    public long index(int slice, int row, int column) {
        return (long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    public IntMatrix3D like(int slices, int rows, int columns) {
        return new SparseIntMatrix3D(slices, rows, columns);
    }

    public IntMatrix2D like2D(int rows, int columns) {
        return new SparseIntMatrix2D(rows, columns);
    }

    public void setQuick(int slice, int row, int column, int value) {
        long index = (long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (value == 0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    public IntMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int viewRows = this.slices;
        int viewColumns = this.rows;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.rowZero;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.rowStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.rowOffsets;
        return new SelectedSparseIntMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    public IntMatrix2D viewRow(int row) {
        this.checkRow(row);
        int viewRows = this.slices;
        int viewColumns = this.columns;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedSparseIntMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    public IntMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int viewRows = this.rows;
        int viewColumns = this.columns;
        int viewRowZero = this.rowZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._sliceOffset(this._sliceRank(slice));
        int viewRowStride = this.rowStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.rowOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedSparseIntMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    protected int _sliceOffset(int absRank) {
        return this.sliceOffsets[absRank];
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D other) {
        if (other instanceof SelectedSparseIntMatrix3D) {
            SelectedSparseIntMatrix3D otherMatrix = (SelectedSparseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseIntMatrix3D) {
            SparseIntMatrix3D otherMatrix = (SparseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    protected void setUp(int slices, int rows, int columns) {
        super.setUp(slices, rows, columns);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int axis0, int axis1, int axis2) {
        super.vDice(axis0, axis1, axis2);
        int[][] offsets = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = offsets[axis0];
        this.rowOffsets = offsets[axis1];
        this.columnOffsets = offsets[axis2];
        return this;
    }

    protected IntMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseIntMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, this.offset);
    }
}

