/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;

class DelegateFloatMatrix2D
extends FloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateFloatMatrix2D(FloatMatrix3D newContent, int axis, int index) {
        switch (axis) {
            case 0: {
                if (index < 0 || index >= newContent.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.rows(), newContent.columns());
                break;
            }
            case 1: {
                if (index < 0 || index >= newContent.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.columns());
                break;
            }
            case 2: {
                if (index < 0 || index >= newContent.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = axis;
        this.index = index;
        this.content = newContent;
    }

    public synchronized float getQuick(int row, int column) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, row, column);
            }
            case 1: {
                return this.content.getQuick(row, this.index, column);
            }
            case 2: {
                return this.content.getQuick(row, column, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public FloatMatrix2D like(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    public synchronized void setQuick(int row, int column, float value) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, row, column, value);
                break;
            }
            case 1: {
                this.content.setQuick(row, this.index, column, value);
                break;
            }
            case 2: {
                this.content.setQuick(row, column, this.index, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public FloatMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        return new WrapperFloatMatrix2D(this).viewColumn(column);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected FloatMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }

    public FloatMatrix1D like1D(int size) {
        throw new InternalError();
    }

    protected FloatMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D v = new DenseFloatMatrix1D(this.rows * this.columns);
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                ((FloatMatrix1D)v).setQuick(idx++, this.getQuick(r, c));
            }
        }
        return v;
    }
}

