/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;

class DelegateFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix2D content;
    protected int row;

    public DelegateFloatMatrix1D(FloatMatrix2D newContent, int row) {
        if (row < 0 || row >= newContent.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(newContent.columns());
        this.row = row;
        this.content = newContent;
    }

    public synchronized float getQuick(int index) {
        return this.content.getQuick(this.row, index);
    }

    public FloatMatrix1D like(int size) {
        return this.content.like1D(size);
    }

    public FloatMatrix2D like2D(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    public synchronized void setQuick(int index, float value) {
        this.content.setQuick(this.row, index, value);
    }

    public Object elements() {
        return this.content.elements();
    }

    public FloatMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FloatMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected FloatMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }
}

