/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;

public class FloatFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatFactory2D dense = new FloatFactory2D();
    public static final FloatFactory2D sparse = new FloatFactory2D();

    protected static void checkRectangularShape(float[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(FloatMatrix2D[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected FloatFactory2D() {
    }

    public FloatMatrix2D appendColumn(FloatMatrix2D A, FloatMatrix1D b) {
        if (b.size() > (long)A.rows()) {
            b = b.viewPart(0, A.rows());
        } else if (b.size() < (long)A.rows()) {
            A = A.viewPart(0, 0, (int)b.size(), A.columns());
        }
        int ac = A.columns();
        int bc = 1;
        int r = A.rows();
        FloatMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewColumn(ac).assign(b);
        return matrix;
    }

    public FloatMatrix2D appendColumns(FloatMatrix2D A, FloatMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        FloatMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public FloatMatrix2D appendRow(FloatMatrix2D A, FloatMatrix1D b) {
        if (b.size() > (long)A.columns()) {
            b = b.viewPart(0, A.columns());
        } else if (b.size() < (long)A.columns()) {
            A = A.viewPart(0, 0, A.rows(), (int)b.size());
        }
        int ar = A.rows();
        int br = 1;
        int c = A.columns();
        FloatMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewRow(ar).assign(b);
        return matrix;
    }

    public FloatMatrix2D appendRows(FloatMatrix2D A, FloatMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        FloatMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public FloatMatrix2D ascending(int rows, int columns) {
        return this.descending(rows, columns).assign(FloatFunctions.chain(FloatFunctions.neg, FloatFunctions.minus(columns * rows)));
    }

    public FloatMatrix2D compose(FloatMatrix2D[][] parts) {
        int row;
        FloatFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        FloatMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                FloatMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                FloatMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        FloatMatrix2D matrix = this.make(resultRows, resultCols);
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                FloatMatrix2D part = parts[row3][column4];
                if (part != null) {
                    matrix.viewPart(r, c, part.rows(), part.columns()).assign(part);
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
        return matrix;
    }

    public FloatMatrix2D composeBidiagonal(FloatMatrix2D A, FloatMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        FloatMatrix2D sum = this.make(ar + br - 1, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar - 1, ac, br, bc).assign(B);
        return sum;
    }

    public FloatMatrix2D composeDiagonal(FloatMatrix2D A, FloatMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        FloatMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public FloatMatrix2D composeDiagonal(FloatMatrix2D A, FloatMatrix2D B, FloatMatrix2D C) {
        FloatMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public void decompose(FloatMatrix2D[][] parts, FloatMatrix2D matrix) {
        int row;
        FloatFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                FloatMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                FloatMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                FloatMatrix2D part = parts[row3][column4];
                if (part != null) {
                    part.assign(matrix.viewPart(r, c, part.rows(), part.columns()));
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        FloatMatrix2D[][] parts1 = new FloatMatrix2D[][]{{null, this.make(2, 2, 1.0f), null}, {this.make(4, 4, 2.0f), null, this.make(4, 3, 3.0f)}, {null, this.make(2, 2, 4.0f), null}};
        System.out.println("\n" + this.compose(parts1));
        FloatMatrix2D[][] parts3 = new FloatMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(parts3));
        FloatMatrix2D A = this.ascending(2, 2);
        FloatMatrix2D B = this.descending(2, 2);
        Object _ = null;
        FloatMatrix2D[][] parts4 = new FloatMatrix2D[][]{{A, _, A, _}, {_, A, _, B}};
        System.out.println("\n" + this.compose(parts4));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object _ = null;
        FloatMatrix2D A = this.make(2, 2, 1.0f);
        FloatMatrix2D B = this.make(4, 4, 2.0f);
        FloatMatrix2D C = this.make(4, 3, 3.0f);
        FloatMatrix2D D = this.make(2, 2, 4.0f);
        FloatMatrix2D[][] parts1 = new FloatMatrix2D[][]{{_, A, _}, {B, _, C}, {_, D, _}};
        FloatMatrix2D matrix = this.compose(parts1);
        System.out.println("\n" + matrix);
        A.assign(9.0f);
        B.assign(9.0f);
        C.assign(9.0f);
        D.assign(9.0f);
        this.decompose(parts1, matrix);
        System.out.println(A);
        System.out.println(B);
        System.out.println(C);
        System.out.println(D);
    }

    public FloatMatrix2D descending(int rows, int columns) {
        FloatMatrix2D matrix = this.make(rows, columns);
        int v = 0;
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                matrix.setQuick(row, column, v++);
            }
        }
        return matrix;
    }

    public FloatMatrix2D diagonal(float[] vector) {
        int size = vector.length;
        FloatMatrix2D diag = this.make(size, size);
        for (int i = 0; i < size; ++i) {
            diag.setQuick(i, i, vector[i]);
        }
        return diag;
    }

    public FloatMatrix2D diagonal(FloatMatrix1D vector) {
        int size = (int)vector.size();
        FloatMatrix2D diag = this.make(size, size);
        int i = size;
        while (--i >= 0) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public FloatMatrix1D diagonal(FloatMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        FloatMatrix1D diag = this.make1D(min);
        int i = min;
        while (--i >= 0) {
            diag.setQuick(i, A.getQuick(i, i));
        }
        return diag;
    }

    public FloatMatrix2D identity(int rowsAndColumns) {
        FloatMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, 1.0f);
        }
        return matrix;
    }

    public FloatMatrix2D make(float[] values, int rows) {
        int columns;
        int n = columns = rows != 0 ? values.length / rows : 0;
        if (rows * columns != values.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        FloatMatrix2D matrix = this.make(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                matrix.setQuick(row, column, values[row + column * rows]);
            }
        }
        return matrix;
    }

    public FloatMatrix2D make(float[][] values) {
        if (this == sparse) {
            return new SparseFloatMatrix2D(values);
        }
        return new DenseFloatMatrix2D(values);
    }

    public FloatMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseFloatMatrix2D(rows, columns);
        }
        return new DenseFloatMatrix2D(rows, columns);
    }

    public FloatMatrix2D make(int rows, int columns, float initialValue) {
        if (initialValue == 0.0f) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    public FloatMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(FloatFunctions.random());
    }

    public FloatMatrix2D repeat(FloatMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        FloatMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = rowRepeat;
        while (--i >= 0) {
            int j = columnRepeat;
            while (--j >= 0) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
            }
        }
        return matrix;
    }

    public FloatMatrix2D sample(FloatMatrix2D matrix, float value, float nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        float epsilon = 1.0E-5f;
        if (nonZeroFraction < 0.0f - epsilon || nonZeroFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0f) {
            nonZeroFraction = 0.0f;
        }
        if (nonZeroFraction > 1.0f) {
            nonZeroFraction = 1.0f;
        }
        matrix.assign(0.0f);
        int size = rows * columns;
        int n = Math.round((float)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        FloatRandomSamplingAssistant sampler = new FloatRandomSamplingAssistant(n, size, new FloatMersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            int row = i / columns;
            int column = i % columns;
            matrix.setQuick(row, column, value);
        }
        return matrix;
    }

    public FloatMatrix2D sample(int rows, int columns, float value, float nonZeroFraction) {
        FloatMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    protected FloatMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }
}

