/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;

public class SparseRCMFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFComplexMatrix1D[] elements;

    public SparseRCMFComplexMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseFComplexMatrix1D[rows];
        for (int i = 0; i < rows; ++i) {
            this.elements[i] = new SparseFComplexMatrix1D(columns);
        }
    }

    public SparseFComplexMatrix1D[] elements() {
        return this.elements;
    }

    public float[] getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    public void setQuick(int row, int column, float[] value) {
        this.elements[row].setQuick(column, value);
    }

    public void setQuick(int row, int column, float re, float im) {
        this.elements[row].setQuick(column, re, im);
    }

    public void trimToSize() {
        for (int r = 0; r < this.rows; ++r) {
            this.elements[r].trimToSize();
        }
    }

    public SparseFComplexMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseRCMFComplexMatrix2D(rows, columns);
    }
}

