/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseFComplexMatrix1D(int size, ConcurrentHashMap<Long, float[]> elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    protected SelectedSparseFComplexMatrix1D(ConcurrentHashMap<Long, float[]> elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    public float[] getQuick(int index) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + index * this.stride]);
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D other) {
        if (other instanceof SelectedSparseFComplexMatrix1D) {
            SelectedSparseFComplexMatrix1D otherMatrix = (SelectedSparseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFComplexMatrix1D) {
            SparseFComplexMatrix1D otherMatrix = (SparseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return (long)this.offset + (long)this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public FComplexMatrix1D like(int size) {
        return new SparseFComplexMatrix1D(size);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return new SparseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int index, float[] value) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (value[0] == 0.0f && value[1] == 0.0f) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public void setQuick(int index, float re, float im) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (re == 0.0f && im == 0.0f) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, new float[]{re, im});
        }
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseFComplexMatrix1D(this.elements, offsets);
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FloatMatrix1D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

