/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.map.tdouble.OpenLongDoubleHashMap;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SelectedSparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;

public class SparseDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongDoubleMap elements;

    public SparseDoubleMatrix1D(double[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseDoubleMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseDoubleMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenLongDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseDoubleMatrix1D(int size, AbstractLongDoubleMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    public DoubleMatrix1D assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    public synchronized double getQuick(int index) {
        return this.elements.get((long)this.zero + (long)index * (long)this.stride);
    }

    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    public DoubleMatrix1D like(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    public DoubleMatrix2D like2D(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseDoubleMatrix2D M = new SparseDoubleMatrix2D(rows, columns);
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                double elem;
                if ((elem = this.getQuick(idx++)) == 0.0) continue;
                ((DoubleMatrix2D)M).setQuick(r, c, elem);
            }
        }
        return M;
    }

    public DoubleMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseDoubleMatrix3D M = new SparseDoubleMatrix3D(slices, rows, columns);
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    double elem;
                    if ((elem = this.getQuick(idx++)) == 0.0) continue;
                    ((DoubleMatrix3D)M).setQuick(s, r, c, elem);
                }
            }
        }
        return M;
    }

    public synchronized void setQuick(int index, double value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value == 0.0) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("1 x ").append(this.size).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.size; ++i) {
            double elem = this.getQuick(i);
            if (elem == 0.0) continue;
            builder.append('(').append(i).append(')').append('\t').append(elem).append('\n');
        }
        return builder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D otherMatrix = (SelectedSparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D otherMatrix = (SparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseDoubleMatrix1D(this.elements, offsets);
    }
}

