/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleChebyshev
extends AbstractDoubleIterativeSolver {
    private double eigmin;
    private double eigmax;
    private DoubleMatrix1D p;
    private DoubleMatrix1D z;
    private DoubleMatrix1D r;
    private DoubleMatrix1D q;

    public DoubleChebyshev(DoubleMatrix1D template, double eigmin, double eigmax) {
        this.p = template.copy();
        this.z = template.copy();
        this.r = template.copy();
        this.q = template.copy();
        this.setEigenvalues(eigmin, eigmax);
    }

    public void setEigenvalues(double eigmin, double eigmax) {
        this.eigmin = eigmin;
        this.eigmax = eigmax;
        if (eigmin <= 0.0) {
            throw new IllegalArgumentException("eigmin <= 0");
        }
        if (eigmax <= 0.0) {
            throw new IllegalArgumentException("eigmax <= 0");
        }
        if (eigmin > eigmax) {
            throw new IllegalArgumentException("eigmin > eigmax");
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        double alpha = 0.0;
        double beta = 0.0;
        double c = 0.0;
        double d = 0.0;
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        c = (this.eigmax - this.eigmin) / 2.0;
        d = (this.eigmax + this.eigmin) / 2.0;
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                alpha = 2.0 / d;
            } else {
                beta = alpha * c / 2.0;
                beta *= beta;
                alpha = 1.0 / (d - beta);
                this.p.assign(this.z, DoubleFunctions.plusMultFirst(beta));
            }
            A.zMult(this.p, this.q);
            x.assign(this.p, DoubleFunctions.plusMultSecond(alpha));
            this.r.assign(this.q, DoubleFunctions.plusMultSecond(-alpha));
            this.iter.next();
        }
        return x;
    }
}

