/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

class SelectedDenseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseDComplexMatrix1D(double[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseDComplexMatrix1D(int size, double[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    public double[] getQuick(int index) {
        int idx = this.zero + index * this.stride;
        return new double[]{this.elements[this.offset + this.offsets[idx]], this.elements[this.offset + this.offsets[idx] + 1]};
    }

    public DoubleMatrix1D getRealPart() {
        final DenseDoubleMatrix1D R = new DenseDoubleMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    double[] tmp;

                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            this.tmp = SelectedDenseDComplexMatrix1D.this.getQuick(k);
                            R.setQuick(k, this.tmp[0]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] tmp = this.getQuick(i);
                R.setQuick(i, tmp[0]);
            }
        }
        return R;
    }

    public DoubleMatrix1D getImaginaryPart() {
        final DenseDoubleMatrix1D Im = new DenseDoubleMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    double[] tmp;

                    public void run() {
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            this.tmp = SelectedDenseDComplexMatrix1D.this.getQuick(k);
                            Im.setQuick(k, this.tmp[1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] tmp = this.getQuick(i);
                Im.setQuick(i, tmp[1]);
            }
        }
        return Im;
    }

    public double[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix1D other) {
        if (other instanceof SelectedDenseDComplexMatrix1D) {
            SelectedDenseDComplexMatrix1D otherMatrix = (SelectedDenseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDComplexMatrix1D) {
            DenseDComplexMatrix1D otherMatrix = (DenseDComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    public DComplexMatrix1D like(int size) {
        return new DenseDComplexMatrix1D(size);
    }

    public DComplexMatrix2D like2D(int rows, int columns) {
        return new DenseDComplexMatrix2D(rows, columns);
    }

    public DComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    public DComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalAccessError("This method is not supported.");
    }

    public void setQuick(int index, double[] value) {
        int idx = this.zero + index * this.stride;
        this.elements[this.offset + this.offsets[idx]] = value[0];
        this.elements[this.offset + this.offsets[idx] + 1] = value[1];
    }

    public void setQuick(int index, double re, double im) {
        int idx = this.zero + index * this.stride;
        this.elements[this.offset + this.offsets[idx]] = re;
        this.elements[this.offset + this.offsets[idx] + 1] = im;
    }

    protected void setUp(int size) {
        super.setUp(size, 0, 1);
        this.offset = 0;
    }

    protected DComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseDComplexMatrix1D(this.elements, offsets);
    }
}

