/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    private DoubleFFT_3D fft3;
    protected double[] elements;

    public DenseDComplexMatrix3D(double[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length / 2));
        this.assign(values);
    }

    public DenseDComplexMatrix3D(DoubleMatrix3D realPart) {
        this(realPart.slices(), realPart.rows(), realPart.columns());
        this.assignReal(realPart);
    }

    public DenseDComplexMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns, 0, 0, 0, rows * 2 * columns, 2 * columns, 2);
        this.elements = new double[slices * rows * 2 * columns];
    }

    public DenseDComplexMatrix3D(int slices, int rows, int columns, double[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isNoView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction aggr, final DComplexDComplexFunction f) {
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0, 0);
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = zero + firstSlice * DenseDComplexMatrix3D.this.sliceStride;
                        double[] a = f.apply(new double[]{DenseDComplexMatrix3D.this.elements[idx], DenseDComplexMatrix3D.this.elements[idx + 1]});
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride + c * DenseDComplexMatrix3D.this.columnStride;
                                    a = aggr.apply(a, f.apply(new double[]{DenseDComplexMatrix3D.this.elements[idx], DenseDComplexMatrix3D.this.elements[idx + 1]}));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new double[]{this.elements[zero], this.elements[zero + 1]});
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        a = aggr.apply(a, f.apply(new double[]{this.elements[idx], this.elements[idx + 1]}));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    @Override
    public double[] aggregate(DComplexMatrix3D other, final DComplexDComplexDComplexFunction aggr, final DComplexDComplexDComplexFunction f) {
        this.checkShape(other);
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final double[] elemsOther = (double[])other.elements();
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = zero + firstSlice * DenseDComplexMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        double[] a = f.apply(new double[]{DenseDComplexMatrix3D.this.elements[idx], DenseDComplexMatrix3D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride + c * DenseDComplexMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                                    a = aggr.apply(a, f.apply(new double[]{DenseDComplexMatrix3D.this.elements[idx], DenseDComplexMatrix3D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new double[]{this.elements[zero], this.elements[zero + 1]}, new double[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                        a = aggr.apply(a, f.apply(new double[]{this.elements[idx], this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexDComplexFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        if (function instanceof DComplexMult) {
                            double[] multiplicator = ((DComplexMult)function).multiplicator;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        elem[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        DenseDComplexMatrix3D.this.elements[idx] = elem[0] * multiplicator[0] - elem[1] * multiplicator[1];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = elem[1] * multiplicator[0] + elem[0] * multiplicator[1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        } else {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        elem[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        elem = function.apply(elem);
                                        DenseDComplexMatrix3D.this.elements[idx] = elem[0];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = elem[1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            if (function instanceof DComplexMult) {
                double[] multiplicator = ((DComplexMult)function).multiplicator;
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            elem[0] = this.elements[idx];
                            elem[1] = this.elements[idx + 1];
                            this.elements[idx] = elem[0] * multiplicator[0] - elem[1] * multiplicator[1];
                            this.elements[idx + 1] = elem[1] * multiplicator[0] + elem[0] * multiplicator[1];
                            idx += this.columnStride;
                        }
                    }
                }
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            elem[0] = this.elements[idx];
                            elem[1] = this.elements[idx + 1];
                            elem = function.apply(elem);
                            this.elements[idx] = elem[0];
                            this.elements[idx + 1] = elem[1];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexProcedure cond, final DComplexDComplexFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    elem[0] = DenseDComplexMatrix3D.this.elements[idx];
                                    elem[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                    if (cond.apply(elem)) {
                                        elem = f.apply(elem);
                                        DenseDComplexMatrix3D.this.elements[idx] = elem[0];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = elem[1];
                                    }
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        elem[0] = this.elements[idx];
                        elem[1] = this.elements[idx + 1];
                        if (cond.apply(elem)) {
                            elem = f.apply(elem);
                            this.elements[idx] = elem[0];
                            this.elements[idx + 1] = elem[1];
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexProcedure cond, final double[] value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    elem[0] = DenseDComplexMatrix3D.this.elements[idx];
                                    elem[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                    if (cond.apply(elem)) {
                                        DenseDComplexMatrix3D.this.elements[idx] = value[0];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = value[1];
                                    }
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        elem[0] = this.elements[idx];
                        elem[1] = this.elements[idx + 1];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value[0];
                            this.elements[idx + 1] = value[1];
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexRealFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        if (function == DComplexFunctions.abs) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        double d;
                                        elem[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        double absX = Math.abs(DenseDComplexMatrix3D.this.elements[idx]);
                                        double absY = Math.abs(DenseDComplexMatrix3D.this.elements[idx + 1]);
                                        if (absX == 0.0 && absY == 0.0) {
                                            DenseDComplexMatrix3D.this.elements[idx] = 0.0;
                                        } else if (absX >= absY) {
                                            d = elem[1] / elem[0];
                                            DenseDComplexMatrix3D.this.elements[idx] = absX * Math.sqrt(1.0 + d * d);
                                        } else {
                                            d = elem[0] / elem[1];
                                            DenseDComplexMatrix3D.this.elements[idx] = absY * Math.sqrt(1.0 + d * d);
                                        }
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = 0.0;
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        } else {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        elem[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        elem[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        elem[0] = function.apply(elem);
                                        DenseDComplexMatrix3D.this.elements[idx] = elem[0];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = 0.0;
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        elem[0] = this.elements[idx];
                        elem[1] = this.elements[idx + 1];
                        elem[0] = function.apply(elem);
                        this.elements[idx] = elem[0];
                        this.elements[idx + 1] = 0.0;
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(DComplexMatrix3D source) {
        if (!(source instanceof DenseDComplexMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseDComplexMatrix3D other = (DenseDComplexMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DComplexMatrix3D c = other.copy();
            if (!(c instanceof DenseDComplexMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseDComplexMatrix3D)c;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride;
        final int rowStrideOther = other.rowStride;
        final int columnStrideOther = other.columnStride;
        final double[] elemsOther = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    DenseDComplexMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    DenseDComplexMatrix3D.this.elements[idx + 1] = elemsOther[idxOther + 1];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = elemsOther[idxOther];
                        this.elements[idx + 1] = elemsOther[idxOther + 1];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(DComplexMatrix3D y, final DComplexDComplexDComplexFunction function) {
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int colStrideOther = y.columnStride();
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final double[] elemsOther = (double[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] tmp1 = new double[2];
                        double[] tmp2 = new double[2];
                        if (function == DComplexFunctions.mult) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        DenseDComplexMatrix3D.this.elements[idx] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        } else if (function == DComplexFunctions.multConjFirst) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        DenseDComplexMatrix3D.this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        } else if (function == DComplexFunctions.multConjSecond) {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        DenseDComplexMatrix3D.this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        } else {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        tmp1[0] = DenseDComplexMatrix3D.this.elements[idx];
                                        tmp1[1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                        tmp2[0] = elemsOther[idxOther];
                                        tmp2[1] = elemsOther[idxOther + 1];
                                        tmp1 = function.apply(tmp1, tmp2);
                                        DenseDComplexMatrix3D.this.elements[idx] = tmp1[0];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = tmp1[1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                        idxOther += colStrideOther;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] tmp1 = new double[2];
            double[] tmp2 = new double[2];
            if (function == DComplexFunctions.mult) {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            this.elements[idx] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                            this.elements[idx + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            } else if (function == DComplexFunctions.multConjFirst) {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                            this.elements[idx + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            } else if (function == DComplexFunctions.multConjSecond) {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            this.elements[idx] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                            this.elements[idx + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                        for (int c = 0; c < this.columns; ++c) {
                            tmp1[0] = this.elements[idx];
                            tmp1[1] = this.elements[idx + 1];
                            tmp2[0] = elemsOther[idxOther];
                            tmp2[1] = elemsOther[idxOther + 1];
                            tmp1 = function.apply(tmp1, tmp2);
                            this.elements[idx] = tmp1[0];
                            this.elements[idx + 1] = tmp1[1];
                            idx += this.columnStride;
                            idxOther += colStrideOther;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final double re, final double im) {
        if (!this.isNoView) {
            return super.assign(re, im);
        }
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    DenseDComplexMatrix3D.this.elements[idx] = re;
                                    DenseDComplexMatrix3D.this.elements[idx + 1] = im;
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = re;
                        this.elements[idx + 1] = im;
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final double[] values) {
        if (values.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idxOther = firstSlice * 2 * DenseDComplexMatrix3D.this.rows * DenseDComplexMatrix3D.this.columns;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        DenseDComplexMatrix3D.this.elements[idx] = values[idxOther++];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = values[idxOther++];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            this.elements[idx] = values[idxOther++];
                            this.elements[idx + 1] = values[idxOther++];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final double[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        final int length = 2 * this.columns;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstSlice * DenseDComplexMatrix3D.this.sliceStride;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                double[][] currentSlice = values[s];
                                if (currentSlice.length != DenseDComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseDComplexMatrix3D.this.rows());
                                }
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    double[] currentRow = currentSlice[r];
                                    if (currentRow.length != length) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2 * columns()=" + length);
                                    }
                                    System.arraycopy(currentRow, 0, DenseDComplexMatrix3D.this.elements, i, length);
                                    i += length;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                for (int s = 0; s < this.slices; ++s) {
                    double[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    for (int r = 0; r < this.rows; ++r) {
                        double[] currentRow = currentSlice[r];
                        if (currentRow.length != length) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2 * columns()=" + length);
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, length);
                        i += length;
                    }
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                double[][] currentSlice = values[s];
                                if (currentSlice.length != DenseDComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseDComplexMatrix3D.this.rows());
                                }
                                for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                    double[] currentRow = currentSlice[r];
                                    if (currentRow.length != length) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + length);
                                    }
                                    for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                        DenseDComplexMatrix3D.this.elements[idx] = currentRow[2 * c];
                                        DenseDComplexMatrix3D.this.elements[idx + 1] = currentRow[2 * c + 1];
                                        idx += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    double[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        double[] currentRow = currentSlice[r];
                        if (currentRow.length != length) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + length);
                        }
                        for (int c = 0; c < this.columns; ++c) {
                            this.elements[idx] = currentRow[2 * c];
                            this.elements[idx + 1] = currentRow[2 * c + 1];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assignImaginary(DoubleMatrix3D other) {
        this.checkShape(other);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final double[] elemsOther = (double[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    DenseDComplexMatrix3D.this.elements[idx + 1] = elemsOther[idxOther];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                    idxOther += colStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx + 1] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += colStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assignReal(DoubleMatrix3D other) {
        this.checkShape(other);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final double[] elemsOther = (double[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    DenseDComplexMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                    idxOther += colStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += colStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    if (DenseDComplexMatrix3D.this.elements[idx] != 0.0 || DenseDComplexMatrix3D.this.elements[idx + 1] != 0.0) {
                                        ++cardinality;
                                    }
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        if (this.elements[idx] != 0.0 || this.elements[idx + 1] != 0.0) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return cardinality;
    }

    public void fft2Slices() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            ((DenseDComplexMatrix2D)DenseDComplexMatrix3D.this.viewSlice(s)).fft2();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                ((DenseDComplexMatrix2D)this.viewSlice(s)).fft2();
            }
        }
    }

    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexForward(this.elements);
        } else {
            DComplexMatrix3D copy = this.copy();
            this.fft3.complexForward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix3D getImaginaryPart() {
        DenseDoubleMatrix3D Im = new DenseDoubleMatrix3D(this.slices, this.rows, this.columns);
        final double[] elemsOther = Im.elements();
        final int sliceStrideOther = Im.sliceStride();
        final int rowStrideOther = Im.rowStride();
        final int columnStrideOther = Im.columnStride();
        final int zeroOther = (int)Im.index(0, 0, 0);
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    elemsOther[idxOther] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        elemsOther[idxOther] = this.elements[idx + 1];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, ArrayList<double[]> valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                for (int c = 0; c < this.columns; ++c) {
                    double[] elem = new double[]{this.elements[idx], this.elements[idx + 1]};
                    if (elem[0] != 0.0 || elem[1] != 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(elem);
                    }
                    idx += this.columnStride;
                }
            }
        }
    }

    @Override
    public double[] getQuick(int slice, int row, int column) {
        int idx = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        return new double[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public DoubleMatrix3D getRealPart() {
        DenseDoubleMatrix3D R = new DenseDoubleMatrix3D(this.slices, this.rows, this.columns);
        final double[] elemsOther = R.elements();
        final int sliceStrideOther = R.sliceStride();
        final int rowStrideOther = R.rowStride();
        final int columnStrideOther = R.columnStride();
        final int zeroOther = (int)R.index(0, 0, 0);
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    elemsOther[idxOther] = DenseDComplexMatrix3D.this.elements[idx];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        elemsOther[idxOther] = this.elements[idx];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return R;
    }

    public void ifft2Slices(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            ((DenseDComplexMatrix2D)DenseDComplexMatrix3D.this.viewSlice(s)).ifft2(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                ((DenseDComplexMatrix2D)this.viewSlice(s)).ifft2(scale);
            }
        }
    }

    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexInverse(this.elements, scale);
        } else {
            DComplexMatrix3D copy = this.copy();
            this.fft3.complexInverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public DComplexMatrix3D like(int slices, int rows, int columns) {
        return new DenseDComplexMatrix3D(slices, rows, columns);
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        return new DenseDComplexMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int slice, int row, int column, double re, double im) {
        int idx = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int slice, int row, int column, double[] value) {
        int idx = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public double[][][] toArray() {
        final int zero = (int)this.index(0, 0, 0);
        final double[][][] values = new double[this.slices][this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            double[][] currentSlice = values[s];
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                double[] currentRow = currentSlice[r];
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    currentRow[2 * c] = DenseDComplexMatrix3D.this.elements[idx];
                                    currentRow[2 * c + 1] = DenseDComplexMatrix3D.this.elements[idx + 1];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                double[][] currentSlice = values[s];
                for (int r = 0; r < this.rows; ++r) {
                    double[] currentRow = currentSlice[r];
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        currentRow[2 * c] = this.elements[idx];
                        currentRow[2 * c + 1] = this.elements[idx + 1];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return values;
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D v = new DenseDComplexMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        for (int s = 0; s < this.slices; ++s) {
            DComplexMatrix2D slice = this.viewSlice(s);
            v.viewPart(s * length, length).assign(slice.vectorize());
        }
        return v;
    }

    @Override
    public double[] zSum() {
        double[] sum = new double[2];
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseDComplexMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseDComplexMatrix3D.this.sliceStride + r * DenseDComplexMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseDComplexMatrix3D.this.columns; ++c) {
                                    sum[0] = sum[0] + DenseDComplexMatrix3D.this.elements[idx];
                                    sum[1] = sum[1] + DenseDComplexMatrix3D.this.elements[idx + 1];
                                    idx += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return sum;
                    }
                });
            }
            try {
                for (int j = 0; j < nthreads; ++j) {
                    double[] tmp = (double[])futures[j].get();
                    sum[0] = sum[0] + tmp[0];
                    sum[1] = sum[1] + tmp[1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        sum[0] = sum[0] + this.elements[idx];
                        sum[1] = sum[1] + this.elements[idx + 1];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix3D other) {
        if (other instanceof SelectedDenseDComplexMatrix3D) {
            SelectedDenseDComplexMatrix3D otherMatrix = (SelectedDenseDComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDComplexMatrix3D) {
            DenseDComplexMatrix3D otherMatrix = (DenseDComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    protected DComplexMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseDComplexMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, false);
    }

    @Override
    protected DComplexMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDComplexMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

