/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatLongProcedure;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractFloatLongMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractFloatLongMap() {
    }

    public boolean containsKey(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final long value) {
        return !this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float iterKey, long iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractFloatLongMap copy() {
        return (AbstractFloatLongMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatLongMap)) {
            return false;
        }
        final AbstractFloatLongMap other = (AbstractFloatLongMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float key, long value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new FloatLongProcedure(){

            public boolean apply(float key, long value) {
                return AbstractFloatLongMap.this.containsKey(key) && AbstractFloatLongMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatLongProcedure procedure) {
        return this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                return procedure.apply(key, AbstractFloatLongMap.this.get(key));
            }
        });
    }

    public abstract long get(float var1);

    public float keyOf(final long value) {
        final float[] foundKey = new float[1];
        boolean notFound = this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float iterKey, long iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Float.NaN;
        }
        return foundKey[0];
    }

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList keyList) {
        this.pairsSortedByValue(keyList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final FloatLongProcedure condition, final FloatArrayList keyList, final LongArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float key, long value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList keyList, LongArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(FloatArrayList keyList, LongArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final float[] k = keyList.elements();
        final long[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                long t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                float t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(float var1, long var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        FloatArrayList theKeys = new FloatArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public LongArrayList values() {
        LongArrayList list = new LongArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final LongArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(AbstractFloatLongMap.this.get(key));
                return true;
            }
        });
    }
}

