/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tdouble;

import cern.colt.PersistentObject;
import cern.colt.buffer.tdouble.DoubleBufferConsumer;
import cern.colt.list.tdouble.DoubleArrayList;

public class DoubleBuffer
extends PersistentObject
implements DoubleBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected DoubleBufferConsumer target;
    protected double[] elements;
    protected DoubleArrayList list;
    protected int capacity;
    protected int size;

    public DoubleBuffer(DoubleBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new double[capacity];
        this.list = new DoubleArrayList(this.elements);
        this.size = 0;
    }

    public void add(double element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    public void addAllOf(DoubleArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

