/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.transformer;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.platform.GraphQlPrinterUtil;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeBuilder;
import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.platform.Utils;
import com.ontotext.platform.transformer.AbstractGraphQlSchemaTransformer;
import com.ontotext.platform.transformer.GraphQlSchemaTransformer;
import graphql.introspection.Introspection;
import graphql.schema.Coercing;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;

public class ApolloGraphQlSchemaTransformer
extends AbstractGraphQlSchemaTransformer {
    private static final String KEY = "key";
    private static final String EXTENDS = "extends";
    private static final String EXTERNAL = "external";
    private static final List<String> FEDERATION_DIRECTIVES = Arrays.asList("key", "external", "extends");
    private static final String ENTITY_TYPE = "_Entity";
    private static final String ANY = "_Any";
    public static final String ENTITIES_PROP = "_entities";
    private static final String ENTITIES_PROP_KEY = "representations";
    private static final String ID = "id";
    private Set<String> usedDirectives;

    @Override
    public void transform(GraphQLSchema.Builder builder) {
        builder.additionalDirectives(this.getDirectives());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized GraphQLSchema transform(GraphQLSchema existingSchema) {
        if (this.usedDirectives == null) {
            throw new IllegalStateException(String.format("Call %s.init() first!", GraphQlSchemaTransformer.class.getSimpleName()));
        }
        try {
            GraphQLSchema graphQLSchema = super.transform(existingSchema);
            return graphQLSchema;
        }
        finally {
            for (String key : FEDERATION_DIRECTIVES) {
                if (this.usedDirectives.contains(key)) {
                    GraphQlPrinterUtil.includeDirective(key);
                    continue;
                }
                GraphQlPrinterUtil.excludeDirective(key);
            }
            this.usedDirectives.clear();
        }
    }

    @Override
    public void init(List<GraphQlSchemaBuilderExtension> builders) {
        this.usedDirectives = new HashSet<String>();
        builders.stream().filter(GraphQlTypeBuilder.class::isInstance).map(GraphQlTypeBuilder.class::cast).findAny().ifPresent(builder -> {
            builder.onObjectTypeCreate(this::addFederationDirectives);
            builder.onInterfaceTypeCreate(this::addFederationDirectives);
            builder.onFieldCreate(this::addFederationDirectives);
        });
    }

    @Override
    protected Set<GraphQLType> getAdditionalTypes(GraphQLSchema existingSchema) {
        HashSet<GraphQLType> types = new HashSet<GraphQLType>(existingSchema.getAdditionalTypes());
        GraphQLScalarType anyType = GraphQLScalarType.newScalar().name(ANY).coercing((Coercing)new Utils.PassThroughCoercing()).build();
        types.add((GraphQLType)anyType);
        GraphQLUnionType.Builder entityTypeBuilder = GraphQLUnionType.newUnionType().name(ENTITY_TYPE);
        TreeSet<GraphQLType> additionalTypes = new TreeSet<GraphQLType>(Comparator.comparing(type -> ((GraphQLNamedSchemaElement)type).getName()));
        additionalTypes.addAll(existingSchema.getAdditionalTypes());
        for (GraphQLType additionalType : additionalTypes) {
            if (!(additionalType instanceof GraphQLObjectType) || !((GraphQLObjectType)additionalType).getDirectives().stream().anyMatch(graphQLDirective -> KEY.equals(graphQLDirective.getName()))) continue;
            entityTypeBuilder.possibleType((GraphQLObjectType)additionalType);
        }
        types.add((GraphQLType)entityTypeBuilder.build());
        return types;
    }

    protected Set<GraphQLDirective> getDirectives() {
        LinkedHashSet<GraphQLDirective> directives = new LinkedHashSet<GraphQLDirective>();
        if (this.usedDirectives.contains(KEY)) {
            GraphQLDirective keyDirective = this.createKeyDirectiveBuilder(null).validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE}).build();
            directives.add(keyDirective);
        }
        if (this.usedDirectives.contains(EXTENDS)) {
            GraphQLDirective extendsDirective = this.createNoFieldDirectiveBuilder(EXTENDS).validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE}).build();
            directives.add(extendsDirective);
        }
        if (this.usedDirectives.contains(EXTERNAL)) {
            GraphQLDirective externalDirective = this.createNoFieldDirectiveBuilder(EXTERNAL).validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.FIELD_DEFINITION}).build();
            directives.add(externalDirective);
        }
        return directives;
    }

    @Override
    protected GraphQLCodeRegistry getCodeRegistry(GraphQLSchema existingSchema) {
        GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry((GraphQLCodeRegistry)existingSchema.getCodeRegistry());
        codeRegistryBuilder.typeResolver(ENTITY_TYPE, env -> {
            GraphQLObjectType object = (GraphQLObjectType)env.getObject();
            return (GraphQLObjectType)env.getSchema().getType(object.getName());
        });
        return codeRegistryBuilder.build();
    }

    @Override
    protected GraphQLObjectType getQueryType(GraphQLSchema existingSchema) {
        GraphQLObjectType.Builder queryTypeBuilder = GraphQLObjectType.newObject((GraphQLObjectType)existingSchema.getQueryType());
        GraphQLFieldDefinition.Builder entitiesBuilder = GraphQLFieldDefinition.newFieldDefinition().name(ENTITIES_PROP).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLTypeReference(ENTITY_TYPE)))).argument(GraphQLArgument.newArgument().name(ENTITIES_PROP_KEY).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)GraphQlTypeUtil.newNonNullListReferenceType(ANY))));
        queryTypeBuilder.field(entitiesBuilder);
        return queryTypeBuilder.build();
    }

    private void addFederationDirectives(GraphQLObjectType.Builder classBuilder, Shape singleShape) {
        if (singleShape.getProperty(ID).isPresent()) {
            classBuilder.withDirective(this.createKeyDirectiveBuilder(ID));
        }
        if (Boolean.TRUE.equals(singleShape.isExtend())) {
            classBuilder.withDirective(this.createNoFieldDirectiveBuilder(EXTENDS));
        }
    }

    private void addFederationDirectives(GraphQLInterfaceType.Builder classBuilder, Shape singleShape) {
        if (singleShape.getProperty(ID).isPresent()) {
            classBuilder.withDirective(this.createKeyDirectiveBuilder(ID));
        }
        if (Boolean.TRUE.equals(singleShape.isExtend())) {
            classBuilder.withDirective(this.createNoFieldDirectiveBuilder(EXTENDS));
        }
    }

    private void addFederationDirectives(GraphQLFieldDefinition.Builder builder, Pair<PropertyShape, String> propShapePair) {
        PropertyShape propertyShape = (PropertyShape)propShapePair.getLeft();
        Shape parentShape = (Shape)propertyShape.getContainedIn().getContainedIn().getContainedIn().get(propShapePair.getRight());
        if (Boolean.TRUE.equals(parentShape.isExtend()) && (propertyShape.getName().equals(ID) || propertyShape.getExternal().booleanValue())) {
            builder.withDirective(this.createNoFieldDirectiveBuilder(EXTERNAL));
        }
    }

    private GraphQLDirective.Builder createKeyDirectiveBuilder(String value) {
        this.usedDirectives.add(KEY);
        return Utils.createDirectiveBuilder(KEY, "fields", value);
    }

    private GraphQLDirective.Builder createNoFieldDirectiveBuilder(String directive) {
        this.usedDirectives.add(directive);
        return Utils.createDirectiveBuilder(directive, null, null);
    }
}

