/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.graphql;

import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.platform.GraphQlFieldArgumentBuilder;
import com.ontotext.platform.GraphQlQueryBuilderExtension;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class CountGraphQlQueryBuilder
implements GraphQlQueryBuilderExtension {
    @Override
    public void build(SomlSchema soml, GraphQLObjectType.Builder queryBuilder, GraphQlSchemaBuilderExtension.Options options) {
        if (!this.isTypeCountingEnabled(soml)) {
            return;
        }
        for (Shape shape : soml.getObjects().values()) {
            if (shape.isSystem() && !shape.getId().equals("Object") || Boolean.TRUE.equals(shape.isSynthetic()) || shape.isIgnoredType() || !shape.getAccessMode().canRead()) continue;
            queryBuilder.field(this.buildObjectCountField(shape));
        }
    }

    private boolean isTypeCountingEnabled(SomlSchema somlSchema) {
        return somlSchema.getConfig().isTypeCountingEnabled().filter(Predicate.isEqual(Boolean.TRUE)).isPresent();
    }

    private GraphQLFieldDefinition.Builder buildObjectCountField(Shape shape) {
        return GraphQLFieldDefinition.newFieldDefinition().name(StringUtils.uncapitalize((String)(shape.asGraphQl() + "_count"))).description("Allows performing count queries with custom criteria").argument(GraphQlFieldArgumentBuilder.where(shape.asGraphQl()).build()).argument(GraphQlFieldArgumentBuilder.repository()).argument(GraphQlFieldArgumentBuilder.includeInferred()).argument(GraphQlFieldArgumentBuilder.expandOverSameAs()).argument(GraphQlFieldArgumentBuilder.from()).argument(GraphQlFieldArgumentBuilder.errorsFormat()).argument(GraphQLArgument.newArgument().name("distinct").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValueProgrammatic((Object)Boolean.FALSE).build()).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLInt));
    }
}

