/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.google.common.primitives.UnsignedInteger;
import com.ontotext.platform.extended.scalars.NumericScalarsUtil;
import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.language.IntValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class UnsignedCoericing<O>
implements Coercing<UnsignedInteger, String> {
    private final String expectedType;
    private final UnsignedInteger maxAllowed;
    private final Function<UnsignedInteger, O> serializationConverter;

    UnsignedCoericing(String expectedType, UnsignedInteger maxAllowed, Function<UnsignedInteger, O> serializationConverter) {
        this.expectedType = expectedType;
        this.maxAllowed = maxAllowed;
        this.serializationConverter = serializationConverter;
    }

    public String serialize(Object dataFetcherResult) {
        return this.serializationConverter.apply(this.convert(dataFetcherResult, CoercingSerializeException::new)).toString();
    }

    @NotNull
    public UnsignedInteger parseValue(Object input) {
        return this.convert(input, CoercingParseValueException::new);
    }

    private UnsignedInteger convert(Object value, Function<String, GraphQLException> excProvider) {
        if (value instanceof Long || value instanceof Integer) {
            try {
                return UnsignedInteger.valueOf((String)value.toString());
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            BigDecimal decimal = NumericScalarsUtil.toDecimal(value);
            if (decimal != null) {
                try {
                    return UnsignedInteger.valueOf((String)decimal.toBigIntegerExact().toString());
                }
                catch (ArithmeticException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        }
        throw excProvider.apply(String.format("Expected type '%s', but was '%s'.", this.expectedType, NumericScalarsUtil.typeName(value)));
    }

    public UnsignedInteger parseLiteral(Object input) {
        NumericScalarsUtil.verifyType(input, IntValue.class, "IntValue");
        BigInteger rawValue = ((IntValue)input).getValue();
        try {
            UnsignedInteger value = UnsignedInteger.valueOf((BigInteger)rawValue);
            if (value.compareTo(UnsignedInteger.ZERO) < 0 || value.compareTo(this.maxAllowed) > 0) {
                throw new CoercingParseLiteralException(String.format("Expected value to be in the '%s' range, but it was '%s'", this.expectedType, rawValue));
            }
            return value;
        }
        catch (IllegalArgumentException iae) {
            throw new CoercingParseLiteralException(String.format("Expected value to be in the '%s' range, but it was '%s'", this.expectedType, rawValue), (Throwable)iae);
        }
    }

    public Value<?> valueToLiteral(Object input, GraphQLContext graphQlContext, Locale locale) {
        return IntValue.newIntValue((BigInteger)this.parseValue(input).bigIntegerValue()).build();
    }
}

